<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use App\Models\BookingSlotHistory;

class BookingExport implements FromCollection,WithHeadings,WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */
    use Exportable;
    Protected $sports;
    Protected $court;
    Protected $status;
    Protected $date;
    public function __construct($req){
        $this->date=$req['date'];
        $this->status=$req['status'];
        $this->court=$req['court'];
        $this->sports=$req['sports'];
    }

    public function collection()
    {
        $instance=BookingSlotHistory::with('Player');
        if($this->sports){
            $instance->where('sports', $this->sports);
         }
        if($this->court){
            $instance->where('court',$this->court);
         }
        if($this->status){
             $instance->where('booking_status',$this->status);
          }
        if($this->date){
             $instance->where('date',$this->date);
          }
         
         return $instance->get();
        
    }
    public function headings(): array
    {
        return ["Id", "Name", "Mobile",  "Sport", "Court", "Slots","Amount","Status","Team Name","Captain Number"];
    }

    public function map($member): array
    {
        return [
            $member->id,
            $member->Player->name,
            $member->Player->mobile,
            $member->sports,
            $member->court,
            $this->getTimings($member->timings),
            $member->price,
            $member->booking_status,
            ($member->team_payload) ? $member->team_payload[0]['name'] : ''  ,
            ($member->team_payload) ? $member->team_payload[1]['cap_no'] : ''  ,
        ];
    }

    public function getTimings($timings){
        $temp="";
            foreach($timings as $_data){
                $temp.=$_data['start_time']."-".$_data['end_time'].",";
            }
            return $temp;
    }

}
