<?php

namespace App\Exports;

use App\Invoice;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use App\Models\Customer;
class UsersExport implements FromCollection,WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    use Exportable;
    Protected $name;
    Protected $gender;
    Protected $mobile;
    Protected $status;
    public function __construct($req){
        $this->name=$req['name'];
        $this->gender=$req['gender'];
        $this->mobile=$req['mobile'];
        $this->status=$req['status'];
    }

    public function collection()
    {
        $instance=Customer::select('id','name','gender','mobile','status');
        if($this->gender){
            $instance->where('gender',  $this->gender);
        }

        if($this->status){
           $instance->where('status', $this->status);
        }

        if( $this->name){
            $instance->where('name', 'like','%'. $this->name.'%');
         }
         
         if( $this->mobile){
            $instance->where('mobile', 'like','%'. $this->mobile.'%');
         }
         return $instance->get();
        
    }
    public function headings(): array
    {
        return ["Id", "Name", "Gender", "Mobile", "Status"];
    }
}
