<?php

use App\Models\Setting;
use App\Models\Notification;
use App\Models\DeviceId;
use App\Models\PlayerMembership;

if (! function_exists('getSetting')) {
    function getSetting($key)
    {
        $data = Setting::where('key', $key)->first();
        if ($data != null) {
            return $data->value;
        } else {
            return 0;
        }
    }
}

function storeNotification($user_id,$title,$description)
{
   $temp=array(
        'user_id'=>$user_id,
        'title'=>$title,
        'description'=>$description,
        'date'=>date('d-m-Y',time()),
        'time'=>date('h:i:s a',time()),
    );

    initPushNorification($user_id,$title,$description);
    $res=Notification::insertGetId($temp);
}
function initPushNorification($user_id,$title,$description){
    $data=DeviceId::select('device_id')->where('user_id',$user_id)->get();
    foreach($data as $dat){
        sendPushNotification($dat->device_id,$title,$description);
    }
}
function sendPushNotification($device_id,$title,$body) {
        $curl = curl_init();
       
        //$device_id="cdMms_aUR-uuR1a2hAsG3G:APA91bGamyDG4ltJxZnzibmxyioCTVqjqloCxH9hCvOOroAu6CZlw-SDnDuecrD3g1Q5FP1V5e9Uy8TrgpMYTwJlNwfluucXdNjOEpOlMg2pT4BeF4-iiV-sAYGMTP8YKC-YGQRq06RT";
        $fields =   [
            'to' => $device_id,
            'notification'=>[
                "body" => $title,
                "title" => $body
            ]
        ];
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://fcm.googleapis.com/fcm/send',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>json_encode( $fields  ),
          CURLOPT_HTTPHEADER => array(
            'Authorization: key =AAAApg2yyT4:APA91bH5Dju3TY-zRD6qDeR1pbi-5zmjqM5KZ-0o2rbDscgsiZEv3ANfc1BOnr9EcsuFJwpNZkPwR1VUtN8C5MKKVl3fPtS2o28MEU4mBmeNA0HljkTUK03SYl_0KdpU4oXSZrApTDtY',
            'Content-Type: application/json'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        //echo $response;

    }

    function isMembershipActive($id){
      
        $status='';
        $membership=PlayerMembership::with(['package'=> function ($query) {
            $query->select('id', 'discount');
        }])->select('start_date','end_date','status','id','pack_id')->where('player_id',$id)->first();
        ($membership==null)   ? $status=false :  $status=true ;
        return $status;
    }
