<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;
use DataTables;
use Image;
use File;
use Exception;
use Cache;
use Cviebrock\EloquentSluggable\Services\SlugService;

class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        try {
            if ($request->ajax()) {
                $catchedCategory= Cache::get('Banner');
                if($catchedCategory){
                    //echo "if";
                    $data=$catchedCategory;
                }else{
                   // echo "else";
                    $this->refreshCache();
                }
                
               // echo json_encode($data);die;

                return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn("action", function ($row) {
                        $btn =
                            '<button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_banner" data-id="' .
                            $row->id .
                            '" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Edit">
                    <span class="svg-icon svg-icon-3">
                    <i class="las la-pen fs-3"></i>
                    </span>
                    </button>
                    <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_banner" id="kt_users_delete_two_step " data-id="' .
                            $row->id .
                            '">
                    <span class="svg-icon svg-icon-3">
                    <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                    </span>
                    </button>';
                        return $btn;
                    })
                    ->editColumn("image", function ($row) {
                        if (isset($row->image) && $row->image != "") {
                            return asset($row->image);
                        }
                        return asset("admin/assets/media/no_img.png");
                    })
                    ->rawColumns(["action"])
                    ->make(true);
            }
            return view("admin.banner");
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate(
            $request,
            [
                "banner_image_json" => "required",
                "banner_name"=>"required",
                "banner_status"=>"required",
            ],
            [
                "banner_image_json.required" => "You have to choose the Banner image!",
                "banner_name.required" => "Banner name is required",
                "banner_status.required"=>"Banner Status is required"
            ]
        );

        try {
           $this->createFolder();
           $des_json_path=public_path("banner/json");
           $jsonFileName = time().'.json';  
           $request->banner_image_json->move($des_json_path, $jsonFileName);
           
           $flight = Banner::firstOrCreate([
                "name" => $request->banner_name,
                "file" =>  "banner/json/" . $jsonFileName,
                'status'=> $request->banner_status,
               
            ]);

            if ($flight) {
                $this->refreshCache();
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Banner added successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );

            echo $e->getMessage();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $Banner = Banner::find($id);
            if (!$Banner) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $Banner],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                "banner_image_json" => "nullable|mimes:pdf,xlx,csv,json|max:2048",
                "banner_name"=>"required",
                "banner_status"=>"required",
            ],
            [
                "banner_image_json.required" => "You have to choose the Banner image!",
                "banner_name.required" => "Banner name is required",
                "banner_status.required"=>"Banner Status is required"
            ]
        );
   try {
            $banner = Banner::find($id);
            $this->createFolder();
           
            //JSON File
            $ImageJson = $request->file("banner_image_json");
            if($ImageJson ){
                $des_json_path=public_path("banner/json");
                $jsonFileName = time().'.json';  
                $request->banner_image_json->move($des_json_path, $jsonFileName);
                $jsonFileName="banner/json/".$jsonFileName;
                $banner->file =$jsonFileName;
            }
            

            $banner->name = $request->banner_name;
            $banner->status = $request->banner_status;
             $res = $banner->save();
             $this->refreshCache();
            if ($res) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Banner Updated successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );  
            echo $e->getMessage();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            $res = Banner::find($id)->delete();
            $this->refreshCache();
            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Banner not deleted",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Banner was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }
   
    public function refreshCache(){
        $data = Banner::select("id", "name", "file", "status")
        ->orderBy("id", "DESC")
        ->get();
        Cache::put('Banner',$data);
    }

    public function createFolder(){
        $path = public_path("banner");
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        $sub_foler_arr = ["json"];
        foreach ($sub_foler_arr as $_data) {
            if (!File::isDirectory($path . "/" . $_data)) {
                File::makeDirectory($path . "/" . $_data, 0777, true, true);
            }
        }

    }
}
