<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Customer;
use App\Models\Venue;
use App\Models\Booking;
use App\Models\BookingSlots;
use App\Models\BookingSlotHistory;
use App\Exports\UsersExport;
use App\Exports\BookingExport;
use DataTables;
use Image;
use File;
use Exception;
use Excel;
class BookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   
    public function index(Request $request)
    {
       
        //
        try {
            if ($request->ajax()) {
                $data = BookingSlotHistory::with('Player')->orderBy('date','DESC');
                
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        if($row->booking_status!='canceled'){
                        $btn = '
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_booking" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        ';
                        return $btn;
                        }
                    })->editColumn('image',function($row){
                        if(isset($row->image) && $row->image!='' ){
                            return asset($row->image);
                        }
                            return asset('admin/assets/media/no_img.png');
                     })
                     ->editColumn('timings',function($row){
                         $temp=[];
                         foreach($row->timings as $_data){
                            $temp[]=$_data['start_time']."-".$_data['end_time'];
                         }
                         return $temp;
    
                        
                    })
                    ->filter(function ($instance) use ($request) {
                        if($request->get('sports')){
                           $instance->where('sports', $request->get('sports'));
                        }

                        if($request->get('court')){
                           $instance->where('court', $request->get('court'));
                        }

                        if($request->get('status')){
                            $instance->where('booking_status', $request->get('status'));
                         }
                         
                         if($request->get('date')){
                            $instance->where('date', $request->get('date'));
                         }
                        
                         
                         })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $Sports=Sports::all();
            return view('admin.booking',compact('Sports'));
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       //   $data=BookingSlotHistory::find($id);
        $booking = BookingSlotHistory::with('Player')->find($id);
        $courts= Venue::where('sports', $booking->request_payload['sport'])->get();
       // echo json_encode($courts);
        //die;
        //Court::
        if($booking){
            return view('admin.includes.partial.booking_edit',compact('booking','id'));
        }
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

   
    public function export(Request $request){
        ($request->date) ?  $date=$request->date :  $date=date('Y-m-d')  ; 
        return Excel::download(new BookingExport($request), 'booking'.$date.'.xlsx');
    }


    public function bookingEdit(Request $request){
            //dd($request->all());
            // "id" => "1"
            // "payment_status" => "refund"
            // "booking_status" => "confirmed"
            // "refund_amount" => "100"
            // "refund_remarks" => "200"
            // "_token" => "80C27f4saPdpeE3BLNe3b3TTuAFArFCDpGxtu2Pm"

            if($request->payment_status=="refund" && $request->booking_status=="canceled"){
               $booking=BookingSlotHistory::where('id',$request->id);
               $clone_booking= clone $booking;
               $data=$clone_booking->first();
               $booking_id=$data->booking_id;
               $this->removeBookingSlot($booking_id);
               $booking->update([
                    'payment_status'=>$request->payment_status,
                    'booking_status'=>$request->booking_status,
                    'refund_remarks'=>json_encode(['amount'=>$request->refund_amount,'remarks'=>$request->refund_remarks])

               ]);
            }else{
                $booking=BookingSlotHistory::where('id',$request->id);
                $booking->update([
                    'payment_status'=>$request->payment_status,
                    'booking_status'=>$request->booking_status,
                    'refund_remarks'=>json_encode([])

               ]);

            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Booking Updated successfully",
                ],
                200
            );



    }

    public function removeBookingSlot($bid){
        Booking::where('id',$bid)->delete();
        BookingSlots::where('booking_id',$bid)->delete();
    }
}
