<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use DataTables;
use Image;
use File;
use Exception;
use Cache;
use Cviebrock\EloquentSluggable\Services\SlugService;
class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

     function __construct()
    {
        
         $this->middleware('permission:category-list', ['only' => ['index','show']]);
         $this->middleware('permission:category-create', ['only' => ['create','store','update']]);
         $this->middleware('permission:category-edit', ['only' => ['create','store']]);
         $this->middleware('permission:category-delete', ['only' => ['destroy']]);
    }
    public function index(Request $request)
    {
        //
        try {
            if ($request->ajax()) {
                $catchedCategory= Cache::get('Category');
                if($catchedCategory){
                    //echo "if";
                    $data=$catchedCategory;
                }else{
                   // echo "else";
                    $this->refreshCache();
                }
                
               // echo json_encode($data);die;

                return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn("action", function ($row) {
                        $btn =
                            '<button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_category" data-id="' .
                            $row->id .
                            '" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Edit">
                    <span class="svg-icon svg-icon-3">
                    <i class="las la-pen fs-3"></i>
                    </span>
                    </button>
                    <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_category" id="kt_users_delete_two_step " data-id="' .
                            $row->id .
                            '">
                    <span class="svg-icon svg-icon-3">
                    <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                    </span>
                    </button>';
                        return $btn;
                    })
                    ->editColumn("image", function ($row) {
                        if (isset($row->image) && $row->image != "") {
                            return asset($row->image);
                        }
                        return asset("admin/assets/media/no_img.png");
                    })
                    ->rawColumns(["action"])
                    ->make(true);
            }
            return view("admin.category");
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate(
            $request,
            [
                "file" => "required|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "category_name" => "required",
            ],
            [
                "file.required" => "You have to choose the category image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "category_name.required" => "Category name is required",
            ]
        );

        try {
            $image = $request->file("file");
            $imageName = time() . "." . $image->extension();
            $path = public_path("category");
            if (!File::isDirectory($path)) {
                File::makeDirectory($path, 0777, true, true);
            }

            $sub_foler_arr = ["thumbnail", "images"];
            foreach ($sub_foler_arr as $_data) {
                if (!File::isDirectory($path . "/" . $_data)) {
                    File::makeDirectory($path . "/" . $_data, 0777, true, true);
                }
            }

            $destinationPathThumbnail = public_path("category/thumbnail");
            $img = Image::make($image->path());
            $img->resize(125, 125, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPathThumbnail . "/" . $imageName);

            $destinationPath = public_path("category/images");
            $image->move($destinationPath, $imageName);

            $flight = Category::firstOrCreate([
                "name" => $request->category_name,
                "slug" => SlugService::createSlug(
                    Category::class,
                    "slug",
                    $request->category_name
                ),
                "image" => "category/thumbnail/" . $imageName,
            ]);

            if ($flight) {
               $this->refreshCache();
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Category added successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $Category = Category::find($id);
            if (!$Category) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $Category],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                "file" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "category_name" => "required",
            ],
            [
                //'file.required' => 'You have to choose the category image!',
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "category_name.required" => "Category name is required",
            ]
        );

        try {
            $category = Category::find($id);
            //dd($category);
            $image = $request->file("file");
            if ($image) {
                $imageName = time() . "." . $image->extension();
                $path = public_path("category");
                if (!File::isDirectory($path)) {
                    File::makeDirectory($path, 0777, true, true);
                }

                $sub_foler_arr = ["thumbnail", "images"];
                foreach ($sub_foler_arr as $_data) {
                    if (!File::isDirectory($path . "/" . $_data)) {
                        File::makeDirectory(
                            $path . "/" . $_data,
                            0777,
                            true,
                            true
                        );
                    }
                }

                $destinationPathThumbnail = public_path("category/thumbnail");
                $img = Image::make($image->path());
                $img->resize(125, 125, function ($constraint) {
                    $constraint->aspectRatio();
                })->save($destinationPathThumbnail . "/" . $imageName);

                $destinationPath = public_path("category/images");
                $image->move($destinationPath, $imageName);
                $filename = "category/thumbnail/" . $imageName;
            } else {
                $filename = $category->image;
            }

            $category->name = $request->category_name;
            $category->slug = SlugService::createSlug(
                Category::class,
                "slug",
                $request->category_name
            );
            $category->image = $filename;
            $res = $category->save();
            if ($res) {
                $this->refreshCache();
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Category Updated successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            $res = Category::find($id)->delete();
            $this->refreshCache();
            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Category not delete user!",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Category was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function refreshCache(){
        $data = Category::select("id", "name", "image", "slug")
        ->orderBy("id", "DESC")
        ->get();
        Cache::put('Category',$data);
    }
}
