<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Customer;
use App\Models\Venue;
use App\Models\Booking;
use App\Models\BookingSlots;
use App\Models\BookingSlotHistory;
use App\Models\CoachingHistory;
use App\Models\CouchingBooking;
use App\Models\CoachingTimings;
use App\Models\Coaching;
use App\Exports\UsersExport;
use App\Exports\BookingExport;
use DataTables;
use Image;
use File;
use Exception;
use Excel;

class CoachingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   
    public function index(Request $request)
    {
       //echo json_encode(CouchingBooking::with(['player'])->get();
        //
        try {
            if ($request->ajax()) {
                $data = CouchingBooking::with(['player','sportsName','courtName','Timings','SessionName']);
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        $btn = '
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_coaching" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        ';
                        return $btn;
                    })
                    ->filter(function ($instance) use ($request) {
                        if($request->get('sports')){
                           $instance->where('sports_id', $request->get('sports'));
                        }

                        if($request->get('court')){
                           $instance->where('court_id', $request->get('court'));
                        }

                        if($request->get('status')){
                            $instance->where('booking_status', $request->get('status'));
                         }
                         
                         if($request->get('date')){
                            $instance->where('join_date','<=', $request->get('date'));
                         }
                         if($request->get('date')){
                            $instance->where('ending_date','>=', $request->get('date'));
                         }
                        
                         
                         })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $Sports=Sports::all();
            return view('admin.coaching',compact('Sports'));
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $coaching = CouchingBooking::with(['player','sportsName','courtName','Timings','SessionName'])
            ->where('id',$id)->first();

        if($coaching){
            $sports=Sports::all();
            $customer_type=config('enums.ctype');
            $customer_level=config('enums.clevel');
            $court=Venue::where('sports',$coaching->sports_id)->get();
            $session=Coaching::with(['weekday'])->where('court_id',$coaching->court_id)->get();
            $weekdays=$session->where('id',$coaching->cst_id)->first()->weekday;
            $timings=CoachingTimings::where('cs_id',$coaching->cst_id)->get(); 
            return view('admin.includes.partial.coaching_edit',compact('timings','weekdays','session','court','sports','customer_level','coaching','id','customer_type'));
        }
    
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
