<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Venue;
use App\Models\Slots;
class CommonController extends Controller
{
    //
    public function getSports($id){
        $sports=Sports::where('category',$id)->get();
        if($sports){
            return response()->json(
                [
                    "success" => true,
                    "data" => $sports,
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "data" => [],
                ],
                200
            );
        }
        
    }

    public function getCourts($id){
        $venues=Venue::where('sports',$id)->get();
        if($venues){
            return response()->json(
                [
                    "success" => true,
                    "data" => $venues,
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "data" => [],
                ],
                200
            );
        }
    }

    public function getSlots($id){
        $slots=Slots::where('court_id',$id)->get();
        if($slots){
            return response()->json(
                [
                    "success" => true,
                    "data" => $slots,
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "data" => [],
                ],
                200
            );
        }
    }
    
}
