<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BookingSlotHistory, App\Models\Customer , Carbon\Carbon , App\Models\PlayerMembership, App\Models\CoachingHistory , App\Models\Complaint,App\Models\Sports;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $book_his_collect=BookingSlotHistory::all();
        $book_history=clone $book_his_collect;
        $book_dashboard_graph=clone $book_his_collect;
        $booking_price_history=clone $book_his_collect;
        $booking_today_price_history=clone $book_his_collect;
        $graph=BookingSlotHistory::query();
        $data['cus_count']=Customer::count();
        $data['last_5_cus']=Customer::orderByDesc('id')->limit(5)->get();
        $data['mem_count']=PlayerMembership::count();
        $data['total_book_count']=$book_his_collect->where('booking_status','confirmed')->count();
        $data['today_book_count']=$book_his_collect->where('date',carbon::today()->format('Y-m-d'))->where('booking_status','confirmed')->count();
        $data['total_booking_revenue']=$booking_price_history->sum('price');
        $data['today_booking_revenue']=$booking_today_price_history->where('date',carbon::today()->format('Y-m-d'))->sum('price');
        $data['today_coaching_revenue']=CoachingHistory::where('slot_status','booked')->sum('amount');
        $data['today_complaint_count']=Complaint::count();
        $data['graph'] = array();
        $data['current_month_revenue'] = 0;
        $data['past_month_revenue'] = 0;
        for ($i = 12; $i >= 0; $i--) {
            $$i= clone $graph;
            $temp=$$i->whereYear('date', '=',  Carbon::today()->startOfMonth()->subMonth($i)->format('Y')) ->whereMonth('date', '=', Carbon::today()->startOfMonth()->subMonth($i))->sum('price');
            $data['graph']['month_data'][]=$temp/1000;
            $data['graph']['month'][]=Carbon::today()->startOfMonth()->subMonth($i)->format('M Y');
            if(Carbon::now()->format('m')==Carbon::today()->startOfMonth()->subMonth($i)->format('m') && Carbon::today()->startOfMonth()->subMonth($i)->format('Y') && Carbon::now()->format('Y')){
                 $data['current_month_revenue']= $temp;
            }
            if(Carbon::now()->subMonth()->format('m')==Carbon::today()->startOfMonth()->subMonth($i)->format('m') && Carbon::today()->startOfMonth()->subMonth($i)->format('Y') && Carbon::now()->subMonth()->format('Y')){
                $data['past_month_revenue']= $temp;
            }
        }

       $sports= Sports::select('name')->withSum('booking','price')->orderBy('booking_sum_price','DESC')->take(5)->get()->toArray();
       $data['sports_cat']=array_column($sports,'name');
       $data['sports_cat_price']=array_column($sports,'booking_sum_price');
       $data['latest_book']=$graph->orderByDesc('id')->limit(10)->get();

       
       return view('admin.dashboard',$data);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
