<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Exception;
use Cache;
use DataTables;
use Hash;
use DB;
use App\Models\Membership\MembershipPlans;
use App\Models\Membership\MembershipDuration;
use App\Models\Membership\MembershipPackage;
class MembershipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
     
        try {
            $package = MembershipPlans::all();
            $duration = MembershipDuration::all();
            if ($request->ajax()) {
                //$this->refreshCache();
                $catchedMembership = Cache::get("membership");
                if ($catchedMembership) {
                    $data = $catchedMembership;
                } else {
                    $this->refreshCache();
                }
                

                return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn("action", function ($row) {
                        $btn =
                            '<button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_membership" data-id="' .
                            $row->id .
                            '" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Edit">
                    <span class="svg-icon svg-icon-3">
                    <i class="las la-pen fs-3"></i>
                    </span>
                    </button>
                    <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_membership" id="kt_users_delete_two_step " data-id="' .
                            $row->id .
                            '">
                    <span class="svg-icon svg-icon-3">
                    <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                    </span>
                    </button>';
                        return $btn;
                    })

                    ->rawColumns(["action"])
                    ->make(true);
            }

            return view(
                "admin.membershipplans",
                compact("package", "duration")
            );
        } catch (Exception $e) {
           echo json_encode($e);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       // dd($request->all());
        //
        $this->validate(
            $request,
            [
                'mem_duration' => 'required|unique:mem_package,dur_id,NULL,NULL,plan_id,' . $request['mem_package'],
                "mem_package" => "required",
                "mem_discount" => "required",
                "mem_price" => "required",
                "mem_dec_title"=>"required"
            ],
            [
                "mem_duration.required" => "Membership Duration is required",
                "mem_duration.unique" => "Your already added membership package for this duration",
                "mem_package.required" => "Membership package is required",
                "mem_price.required" => "Price is required",
                "mem_dec_title.required" => "Title is required"
            ]
        );
      //  dd($request->mem_dec_title);
        for($i=0;$i<count($request->mem_dec_title);$i++){
            $temp[]=array(
                'title'=> isset($request->mem_dec_title[$i]) ?  $request->mem_dec_title[$i] :  ''   , 
                'offer'=> isset($request->mem_dec_title1[$i]) ? $request->mem_dec_title1[$i] : ''  , 
                'description'=>isset($request->mem_dec_desc[$i]) ? $request->mem_dec_desc[$i] : '' 
            );
        }
        $des_json_path=public_path("membership/json");
        $jsonFileName = time().'.json';  
        $request->image_json->move($des_json_path, $jsonFileName);
        $response = MembershipPackage::Create([
            "dur_id" => $request->mem_duration,
            "plan_id" => $request->mem_package,
            "price" => $request->mem_price,
            "discount" => $request->mem_discount,
            "image_json" => 'membership/json/'.$jsonFileName,
            "membership_description" => json_encode($temp),
        ]);
       
        if ($response) {
            $this->refreshCache();
            return response()->json(
                [
                    "success" => true,
                    "message" => "Membership plan added Successfully!",
                ],
                200
            );
        } else {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Membership plan cant able to add",
                ],
                200
            );
        }

       
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
 
            $User = MembershipPackage::with("duration", "plan")->find($id);
           //echo json_encode($User);
            if (!$User) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $User],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                //'mem_duration' => 'required|unique:membership_plans,duration_id,'.$request->input('id').',id,package_id,' . $request['mem_package'],
                'mem_duration' => 'required|unique:mem_package,dur_id,' . $id. ',id,plan_id,' . $request['mem_package'],
                "mem_package" => "required",
                "mem_discount" => "required",
                "mem_price" => "required"
            ],
            [
                "mem_duration.required" => "Membership Duration is required",
                "mem_duration.unique" => "Your already added membership package for this duration",
                "mem_package.required" => "Membership package is required",
                "mem_price.required" => "Price is required",
                "mem_dec_title.required" => "Title is required"
            ]
        );

        for($i=0;$i<count($request->mem_dec_title);$i++){
            $temp[]=array(
                'title'=> isset($request->mem_dec_title[$i]) ?  $request->mem_dec_title[$i] :  ''   , 
                'offer'=> isset($request->mem_dec_title1[$i]) ? $request->mem_dec_title1[$i] : ''  , 
                'description'=>isset($request->mem_dec_desc[$i]) ? $request->mem_dec_desc[$i] : '' 
            );
        }
       $temp_data=[
            "dur_id" => $request->mem_duration,
            "plan_id" => $request->mem_package,
            "price" => $request->mem_price,
            "discount" => $request->mem_discount,
            "membership_description" => json_encode($temp),
       ];
        if($request->image_json){
            $des_json_path=public_path("membership/json");
            $jsonFileName = time().'.json';  
            $request->image_json->move($des_json_path, $jsonFileName);
            $temp_data['image_json']= 'membership/json/'.$jsonFileName;
        }
        $response = MembershipPackage::where('id',$id)->Update($temp_data);
       
        if ($response) {
            $this->refreshCache();
            return response()->json(
                [
                    "success" => true,
                    "message" => "Membership plan updated Successfully!",
                ],
                200
            );
        } else {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Membership plan cant able to update",
                ],
                200
            );
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            $res = MembershipPackage::find($id)->delete();
            $this->refreshCache();
            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Some thing went to wrong!",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Plan was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function refreshCache()
    {
        $data = MembershipPackage::select("*")
            ->with("duration", "plan")
            ->orderBy("id", "DESC")
            ->get();
        Cache::put("membership", $data);
    }
}
