<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Customer;
use App\Exports\UsersExport;
use DataTables;
use Image;
use File;
use Exception;
use Excel;

class PlayersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        //
        try {
            if ($request->ajax()) {
                $data = Customer::withCount('bookings')->orderBy('id','DESC');
                
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        $btn = '
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_customer" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_customer" data-id="'.$row->id.'" id="kt_users_delete_two_step">
                        <span class="svg-icon svg-icon-3">
                        <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                        </span>
                        </button>';
                        return $btn;
                    })->editColumn('image',function($row){
                        if(isset($row->image) && $row->image!='' ){
                            return asset($row->image);
                        }
                            return asset('admin/assets/media/no_img.png');
    
    
                        
                    })
                    ->filter(function ($instance) use ($request) {
                        if($request->get('gender')){
                            $gender=$request->get('gender');
                          // $instance->whereHas('sports.category', $request->get('category'));
                             $instance->where('gender', $gender);
                        }

                        if($request->get('status')){
                           $instance->where('status', $request->get('status'));
                        }

                        if($request->get('name')){
                            $instance->where('name', 'like','%'.$request->get('name').'%');
                         }
                         
                         if($request->get('mobile')){
                            $instance->where('mobile', 'like','%'.$request->get('mobile').'%');
                         }
                        
                         
                         })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $category=Category::all();
            return view('admin.players',compact('category'));
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $this->validate(
            $request,
            [
                "file" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "customer_name" => "required",
                "customer_gender"=>"required",
                //"customer_mobile"=> "required|unique:custom_slots",
                'customer_mobile' => 'required|unique:players,mobile',
                "customer_status"=>"required"
            ],
            [
                "file.required" => "You have to choose the Sports image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "customer_name.required" => "Cuctomer name is required",
                "customer_mobile.unique" => "Mobile number alreay exits",
                "customer_gender.required"=>"Gender is required",
                "customer_mobile.required"=>"Mobile is required",
                "customer_status.required"=>"Please select customer status"
            ]
        );
        try {
            $image = $request->file("file");
            if($image){
                $imageName = time() . "." . $image->extension();
                $this->createFolder();
                $destinationPathThumbnail = public_path("photo/thumbnail");
                $img = Image::make($image->path());
                $img->resize(125, 125, function ($constraint) {
                    $constraint->aspectRatio();
                })->save($destinationPathThumbnail . "/" . $imageName);
                $destinationPath = public_path("photo/images");
                $image->move($destinationPath, $imageName);
                $filename="photo/thumbnail/".$imageName;
            }else{
                $filename="photo/thumbnail/default.jpg";
            }
            $flight = Customer::firstOrCreate([
                "name" => $request->customer_name,
                "mobile" => $request->customer_mobile,
                "gender" =>$request->customer_gender,
                "photo" =>  $filename,
                "status" =>  $request->customer_status,
                "referal_code" =>  $this->generateReferalCode(),
                'used_referal'=> 'no'
            ]);
            if ($flight) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Sports added successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );

            echo $e->getMessage();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
           $customer = Customer::find($id);
            if (!$customer) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" =>$customer],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                "file" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "customer_name" => "required",
                "customer_gender"=>"required",
                //"customer_mobile"=> "required|unique:custom_slots",
                'customer_mobile' => 'required|unique:players,mobile,'.$id,
              
                "customer_status"=>"required"
            ],
            [
                "file.required" => "You have to choose the Sports image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "customer_name.required" => "Cuctomer name is required",
                "customer_mobile.unique" => "Mobile number alreay exits",
                "customer_gender.required"=>"Gender is required",
                "customer_mobile.required"=>"Mobile is required",
                "customer_status.required"=>"Please select customer status"
            ]
        );

        try {
           $customer = Customer::find($id);
            $this->createFolder();
            //dd($sports);
            $image = $request->file("file");
            if ($image) {
                $imageName = time() . "." . $image->extension();
                $destinationPathThumbnail = public_path("photo/thumbnail");
                $img = Image::make($image->path());
                $img->resize(125, 125, function ($constraint) {
                    $constraint->aspectRatio();
                })->save($destinationPathThumbnail . "/" . $imageName);

                $destinationPath = public_path("sports/images");
                $image->move($destinationPath, $imageName);
                $filename = "photo/thumbnail/" . $imageName;
                 $customer->photo = $filename;
                
            }
           $customer->name = $request->customer_name;
           $customer->gender = $request->customer_gender;
           $customer->mobile = $request->customer_mobile;
           $customer->status = $request->customer_status;
           $res =$customer->save();
            if ($res) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Customer Updated successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );  
            echo $e->getMessage();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $res = Customer::find($id)->delete();

            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Customer not deleted !",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Customer was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function types(){
        return view('admin.playerstypes');
    }

    public function createFolder(){
        $path = public_path("photo");
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        $sub_foler_arr = ["thumbnail", "images"];
        foreach ($sub_foler_arr as $_data) {
            if (!File::isDirectory($path . "/" . $_data)) {
                File::makeDirectory($path . "/" . $_data, 0777, true, true);
            }
        }

    }
    public function generateReferalCode($str='innoblitz')
    {
      
    
          // get random number min & max 4 digit
          $randomNumber = rand(1000, 9999);
          // get the first 4 character and trim whitespace
          $strName = trim(substr($str, 0, 4));
          // get str length
          $strLen = strlen($strName);
        
          // If str length less then 4 add missing x character by random str
          $substrName = $strLen < 4 ? $strName . Str::random(4 - $strLen) : $strName;
          // make name uppercase and concat with the random number
          $referral = strtoupper($substrName) . $randomNumber;
          
          return $referral;
    }

    public function export(Request $request){
        $req=$request->all();
        return Excel::download(new UsersExport($req), 'users.xlsx');
    }
}
