<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Venue;
use App\Models\Booking;
use App\Models\BookingSlots;
use App\Models\BookingSlotHistory;
use App\Exports\UsersExport;
use App\Exports\BookingExport;
use DataTables;
use Image;
use File;
use Exception;
use Excel;
class ReportController extends Controller
{
    //
    public function booking(Request $request){
         //
         $sports_count= Sports::select('name')->withCount('bookingReports')
         ->orderBy('booking_reports_count','DESC')->get()->toArray();
        //"name" => "Cricket"
        //"booking_reports_count" => 2
         if ($request->ajax()) {
                $data = BookingSlotHistory::with('Player')->orderBy('date','DESC');
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        $btn = '
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_booking" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        ';
                        return $btn;
                    })->editColumn('image',function($row){
                        if(isset($row->image) && $row->image!='' ){
                            return asset($row->image);
                        }
                            return asset('admin/assets/media/no_img.png');
                     })
                     ->editColumn('timings',function($row){
                         $temp=[];
                         foreach($row->timings as $_data){
                            $temp[]=$_data['start_time']."-".$_data['end_time'];
                         }
                         return $temp;
                    })
                    ->filter(function ($instance) use ($request) {
                        if($request->get('sports')){
                           $instance->where('sports', $request->get('sports'));
                        }

                        if($request->get('court')){
                           $instance->where('court', $request->get('court'));
                        }

                        if($request->get('status')){
                            $instance->where('booking_status', $request->get('status'));
                         }
                         
                         if($request->get('date')){
                            $instance->where('date', $request->get('date'));
                         }
                        
                         
                         })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $Sports=Sports::all();
            return view('admin.reports.booking',compact('Sports','sports_count'));

      
    }

    public function coaching(){

    }

    public function bookingPost(Request $request){
       
         $sports_count=Sports::select('name')->withCount(['bookingReports' => function($q) use($request) {
               if($request->get('book_from_date')){
                   $q->where('date','>=', $request->get('book_from_date'));
                 }
                 if($request->get('book_to_date')){
                    $q->where('date','<=', $request->get('book_to_date'));
                  }
                 if($request->get('book_sport')){
                    $q->where('sports_id', $request->get('book_sport'));
                 }

                 if($request->get('book_court')){
                    $q->where('court', $request->get('book_court'));
                 }

                 if($request->get('book_status')){
                     $q->where('booking_status', $request->get('book_status'));
                  }
            }])->orderBy('booking_reports_count','DESC')->get()->toArray();
         
            $Sports=Sports::all();
           return view('admin.reports.includes.booking_reports',compact('Sports','sports_count'))->render();
    }
    public function customer(){
        $users = Customer::select(\DB::raw("COUNT(*) as count"))
        ->whereYear('created_at', date('Y'))
        ->groupBy(\DB::raw("Month(created_at)"))
        ->pluck('count');
        return view('admin.reports.customer',compact('users'));
    }
}
