<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Exception;
use Cache;
use DataTables;
use Hash;
use DB;
class RoleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        try {
            $permission = Permission::get();
           
            if ($request->ajax()) {
                $catchedUsers= Cache::get('Roles');
                if($catchedUsers){
                    //echo "if";
                    $data=$catchedUsers;
                }else{
                   // echo "else";
                    $this->refreshCache();
                }
                
               // echo json_encode($data);die;

                return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn("action", function ($row) {
                        $btn =
                            '<button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto edit_role" data-id="' .
                            $row->id .
                            '" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Edit">
                    <span class="svg-icon svg-icon-3">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.3" d="M21.4 8.35303L19.241 10.511L13.485 4.755L15.643 2.59595C16.0248 2.21423 16.5426 1.99988 17.0825 1.99988C17.6224 1.99988 18.1402 2.21423 18.522 2.59595L21.4 5.474C21.7817 5.85581 21.9962 6.37355 21.9962 6.91345C21.9962 7.45335 21.7817 7.97122 21.4 8.35303ZM3.68699 21.932L9.88699 19.865L4.13099 14.109L2.06399 20.309C1.98815 20.5354 1.97703 20.7787 2.03189 21.0111C2.08674 21.2436 2.2054 21.4561 2.37449 21.6248C2.54359 21.7934 2.75641 21.9115 2.989 21.9658C3.22158 22.0201 3.4647 22.0084 3.69099 21.932H3.68699Z" fill="currentColor"></path>
                        <path d="M5.574 21.3L3.692 21.928C3.46591 22.0032 3.22334 22.0141 2.99144 21.9594C2.75954 21.9046 2.54744 21.7864 2.3789 21.6179C2.21036 21.4495 2.09202 21.2375 2.03711 21.0056C1.9822 20.7737 1.99289 20.5312 2.06799 20.3051L2.696 18.422L5.574 21.3ZM4.13499 14.105L9.891 19.861L19.245 10.507L13.489 4.75098L4.13499 14.105Z" fill="currentColor"></path>
                    </svg>
                    </span>
                    </button>
                    <button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto delete_role" id="kt_users_delete_two_step " data-id="' .
                            $row->id .
                            '">
                    <span class="svg-icon svg-icon-3">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path>
                        <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path>
                        <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path>
                    </svg>
                    </span>
                    </button>';
                        return $btn;
                    })
                   
                    ->rawColumns(["action"])
                    ->make(true);
            }
          return view('admin.roles',compact('permission'));
         
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
       
        $this->validate($request, [
            'role_name' => 'required|unique:roles,name',
            'permission' => 'required',
        ]);
    try{
        $role = Role::create(['name' => $request->input('role_name'),'guard_name' => 'web']);
        $role->syncPermissions($request->input('permission'));
                if (!$role) {
                                return response()->json(
                                            [
                                                "success" => false,
                                                "message" => "Some thing went to wrong!",
                                            ],
                                            424
                                );
                            }
                        
                            $this->refreshCache();
                            return response()->json(
                                        [
                                            "success" => true,
                                            "message" => "Role created successfully!",
                                        ],
                                        200
                                );
      }catch(Exception $e){
        return response()->json(
            [
                "success" => false,
                "message" => "Some thing went to wrong!",
            ],
            424
        );
      }
       
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
 
            $role = Role::find($id);
            $rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
                ->where("role_has_permissions.role_id",$id)
                ->get()->toArray();
            if (!$role) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }
          
        //    $rp=array_column($rolePermissions,'permission_id');
            $lp_array = array_column(($rolePermissions), 'permission_id');
       
            return response()->json(
                ["success" => true, "data" => array('role'=>$role,'rolePermissions'=>$lp_array)],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'role_name' => "required|unique:roles,name,".$id,
            'permission' => 'required',
          
        ]);
        
        try{
        $role = Role::find($id);
        $role->name = $request->input('role_name');
        $role->save();
        $role->syncPermissions($request->input('permission'));
        if($role){
            $this->refreshCache();
            return response()->json(
                [
                    "success" => true,
                    "message" => "Role Updated Successfully!",
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "message" => "Role Can't able to update",
                ],
                200
            );
        }
        }
        catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Role Can't able to update",
                ],
                200
            );
        }
    
      
                       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $res = Role::find($id)->delete();
            $this->refreshCache();
            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Some thing went to wrong!",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Role was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function refreshCache(){
        $data = Role::select('*')
        ->orderBy("id", "DESC")
        ->get();
        Cache::put('Roles',$data);
    }
}
