<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $data['setting']=Setting::all();
        return view('admin.setting.site-setting',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
       $this->validate(
            $request,
            [
                "playcoin_cashback_nuser" => "required",
                "playcoin_cashback_muser" => "required",
                "play_coin_max_use" => "required",
                "referal_sender_gain" => "required",
                "referal_receiver_gain" => "required",
                "referal_link" => "required",
                "refund_percentage" => "required",
                "cancel_approve_max_hour" => "required",
            ],
            [
                "playcoin_cashback_nuser.required" => "Required - Playcoin Cashback percentage for normal user",
                "playcoin_cashback_muser.mimes" => "Required - Playcoin Cashback percentage for membership user",
                "play_coin_max_use.required" => "Required - Playcoin max use",
                "referal_sender_gain.required" => "Required - Referal sender get amount",
                "referal_receiver_gain.required" => "Required - Referal receiver get amount",
                "referal_link.required" => "Required - Referal Link",
                "refund_percentage.required" => "Required - Refund Percentage",
                "cancel_approve_max_hour.required" => "Required - Cancel Approve with Max hour ",
            ]
        );

    try
    {
        $setting=Setting::query();
        if(isset($request->playcoin_cashback_nuser)){
            $setting->updateOrCreate(['key'=>'playcoin_cashback_nor_user'],
            ['key'=>'playcoin_cashback_nor_user','value'=>$request->playcoin_cashback_nuser]);
        }

        if(isset($request->playcoin_cashback_muser)){
            $temp=Setting::query();
            $temp->updateOrCreate(['key'=>'playcoin_cashback_mem_user'],
            ['key'=>'playcoin_cashback_mem_user','value'=>$request->playcoin_cashback_muser]);
        }

        if(isset($request->referal_sender_gain)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'referal_sender'],
            ['key'=>'referal_sender','value'=>$request->referal_sender_gain]);
        }

        if(isset($request->referal_receiver_gain)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'referal_receiver'],
            ['key'=>'referal_receiver','value'=>$request->referal_receiver_gain]);
        }

        if(isset($request->referal_link)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'referal_link'],
            ['key'=>'referal_link','value'=>$request->referal_link]);
        }

        if(isset($request->refund_percentage)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'refund_per'],
            ['key'=>'refund_per','value'=>$request->refund_percentage]);
        }

        if(isset($request->cancel_approve_max_hour)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'canceL_approve_max_hour'],
            ['key'=>'canceL_approve_max_hour','value'=>$request->cancel_approve_max_hour]);
        }
       
        if(isset($request->play_coin_max_use)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'playcoin_max_usage'],
            ['key'=>'playcoin_max_usage','value'=>$request->play_coin_max_use]);
        }

        if(isset($request->roi)){
            $temp1=Setting::query();
            $temp1->updateOrCreate(['key'=>'roi'],
            ['key'=>'roi','value'=>$request->roi]);
        }

        
        return response()->json(
            [
                "success" => true,
                "message" => "Setting Updated Succesfully",
            ],
            200
        );

    } catch (Exception $e) {
        // return response()->json(
        //     [
        //         "success" => false,
        //         "message" => "Some issue.Please contact admin",
        //     ],
        //     204
        // );
       // echo $e->getMessage();
    }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function playCoin(){
        return view('admin.setting.playcoin');
    }

    public function referal(){
        return view('admin.setting.referal');
    }
}
