<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use DataTables;
use Image;
use File;
use Exception;
use Cviebrock\EloquentSluggable\Services\SlugService;
class SportsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        //
        try {
            if ($request->ajax()) {
                $data = Sports::with('category')->select('id','category','name','image','slug')->orderBy('id','DESC')->get();
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        $btn = '<button type="button" class="btn btn-icon btn-success w-30px h-30px ms-auto view_courts" data-id="'.$row->id.'" id="kt_users_delete_two_step">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-eye fs-3"></i>
                    </span>
                        </button>
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_sports" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_sports" data-id="'.$row->id.'" id="kt_users_delete_two_step">
                        <span class="svg-icon svg-icon-3">
                        <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                        </span>
                        </button>';
                        return $btn;
                    })->editColumn('image',function($row){
                        if(isset($row->image) && $row->image!='' ){
                            return asset($row->image);
                        }
                            return asset('admin/assets/media/no_img.png');
    
    
                        
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $category=Category::all();
            return view('admin.sports',compact('category'));
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate(
            $request,
            [
                "file" => "required|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "category_type" => "required",
                "sports_name"=>"required",
                "sports_type"=>"required",
                //"image_json"=>'required|mimes:pdf,xlx,csv,json|max:2048',
                "sports_price"=>"required",
                "sports_mem_price"=>"required",
                "app_bg_image"=>"nullable|image|mimes:jpeg,png,jpg,gif,svg|max:8000",
            ],
            [
                "file.required" => "You have to choose the Sports image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "category_name.required" => "Category name is required",
                "sports_name.required"=>"Sports name is required",
                "sports_type.required"=>"Sports type is required",
                "image_json.mimes"=>"Please enter valid json farmat",
                "sports_type.required"=>"Sports type is required"
            ]
        );

        try {
            $image = $request->file("file");
            $imageName = time() . "." . $image->extension();
            $this->createFolder();
            $destinationPathThumbnail = public_path("sports/thumbnail");
            $img = Image::make($image->path());
            $img->resize(125, 125, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPathThumbnail . "/" . $imageName);
            $destinationPath = public_path("sports/images");
            $image->move($destinationPath, $imageName);

            $des_json_path=public_path("sports/json");
          // $jsonFileName = time().'.'.$request->image_json->extension();  
            $jsonFileName = time().'.json';  
            $request->image_json->move($des_json_path, $jsonFileName);

            $img_bg_path=public_path("sports/background");
            $imgBgFileName = time().'.'.$request->app_bg_image->extension();  
            $request->app_bg_image->move($img_bg_path, $imgBgFileName);

            $flight = Sports::firstOrCreate([
                "name" => $request->sports_name,
                "category" => $request->category_type,
                "slug" => SlugService::createSlug(
                    Sports::class,
                    "slug",
                    $request->sports_name
                ),
                "image" => "sports/thumbnail/" . $imageName,
                "background_image" =>  "sports/background/" . $imgBgFileName,
                "image_json" =>  "sports/json/" . $jsonFileName,
                "type" =>  $request->sports_type,
                'member_price'=> $request->sports_mem_price,
                'price'=> $request->sports_price, 
            ]);

            if ($flight) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Sports added successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );

            echo $e->getMessage();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
            $sports = Sports::find($id);
            if (!$sports) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $sports],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate(
            $request,
            [
                "file" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "category_type" => "required",
                "sports_name"=>"required",
                "sports_type"=>"required",
                //"image_json"=>'required|mimes:pdf,xlx,csv,json|max:2048',
                "sports_price"=>"required",
                "sports_mem_price"=>"required",
                "app_bg_image"=>"nullable|image|mimes:jpeg,png,jpg,gif,svg|max:8000",
            ],
            [
                "file.required" => "You have to choose the Sports image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "category_name.required" => "Category name is required",
                "sports_name.required"=>"Sports name is required",
                "sports_type.required"=>"Sports type is required",
                "image_json.mimes"=>"Please enter valid json farmat",
                "sports_type.required"=>"Sports type is required"
            ]
        );

        try {
            $sports = Sports::find($id);
            $this->createFolder();
            //dd($sports);
            $image = $request->file("file");
            if ($image) {
                $imageName = time() . "." . $image->extension();
                $destinationPathThumbnail = public_path("sports/thumbnail");
                $img = Image::make($image->path());
                $img->resize(125, 125, function ($constraint) {
                    $constraint->aspectRatio();
                })->save($destinationPathThumbnail . "/" . $imageName);

                $destinationPath = public_path("sports/images");
                $image->move($destinationPath, $imageName);
                $filename = "sports/thumbnail/" . $imageName;
                $sports->image = $filename;
                
            }


            //BG Image
            $bgimage = $request->file("app_bg_image");
            if ($bgimage) {
                $img_bg_path = public_path("sports/background");
                $imgBgFileName = time().'.'.$request->app_bg_image->extension();  
                $request->app_bg_image->move($img_bg_path, $imgBgFileName);
                $imgBgFileName = "sports/background/".$imgBgFileName;
                $sports->background_image = $imgBgFileName;
              
            } 


            //JSON File
            $ImageJson = $request->file("image_json");
            if($ImageJson ){
                $des_json_path=public_path("sports/json");
                $jsonFileName = time().'.json';  
                $request->image_json->move($des_json_path, $jsonFileName);
                $jsonFileName="sports/json/".$jsonFileName;
                $sports->image_json =$jsonFileName;
            }
            

            $sports->name = $request->sports_name;
            $sports->category = $request->category_type;
            $sports->slug = SlugService::createSlug(
                Sports::class,
                "slug",
                $request->sports_name
            );
         
            $res = $sports->save();
            if ($res) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Sports Updated successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );  
            echo $e->getMessage();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            $res = Sports::find($id)->delete();

            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Sports not deleted !",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Sports was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function createFolder(){
        $path = public_path("sports");
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        $sub_foler_arr = ["thumbnail", "images","json","background"];
        foreach ($sub_foler_arr as $_data) {
            if (!File::isDirectory($path . "/" . $_data)) {
                File::makeDirectory($path . "/" . $_data, 0777, true, true);
            }
        }

    }
}
