<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Exception;
use Cache;
use DataTables;
use Hash;
use DB;
class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        try {
            if ($request->ajax()) {
                $catchedUsers= Cache::get('Users');
                if($catchedUsers){
                    //echo "if";
                    $data=$catchedUsers;
                }else{
                   // echo "else";
                    $this->refreshCache();
                }
                
               // echo json_encode($data);die;

                return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn("action", function ($row) {
                        $btn =
                            '<button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto edit_user" data-id="' .
                            $row->id .
                            '" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Edit">
                    <span class="svg-icon svg-icon-3">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.3" d="M21.4 8.35303L19.241 10.511L13.485 4.755L15.643 2.59595C16.0248 2.21423 16.5426 1.99988 17.0825 1.99988C17.6224 1.99988 18.1402 2.21423 18.522 2.59595L21.4 5.474C21.7817 5.85581 21.9962 6.37355 21.9962 6.91345C21.9962 7.45335 21.7817 7.97122 21.4 8.35303ZM3.68699 21.932L9.88699 19.865L4.13099 14.109L2.06399 20.309C1.98815 20.5354 1.97703 20.7787 2.03189 21.0111C2.08674 21.2436 2.2054 21.4561 2.37449 21.6248C2.54359 21.7934 2.75641 21.9115 2.989 21.9658C3.22158 22.0201 3.4647 22.0084 3.69099 21.932H3.68699Z" fill="currentColor"></path>
                        <path d="M5.574 21.3L3.692 21.928C3.46591 22.0032 3.22334 22.0141 2.99144 21.9594C2.75954 21.9046 2.54744 21.7864 2.3789 21.6179C2.21036 21.4495 2.09202 21.2375 2.03711 21.0056C1.9822 20.7737 1.99289 20.5312 2.06799 20.3051L2.696 18.422L5.574 21.3ZM4.13499 14.105L9.891 19.861L19.245 10.507L13.489 4.75098L4.13499 14.105Z" fill="currentColor"></path>
                    </svg>
                    </span>
                    </button>
                    <button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto delete_user" id="kt_users_delete_two_step " data-id="' .
                            $row->id .
                            '">
                    <span class="svg-icon svg-icon-3">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path>
                        <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path>
                        <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path>
                    </svg>
                    </span>
                    </button>';
                        return $btn;
                    })
                    ->addColumn("role", function ($row) {
                        //return  $row->getRoleNames();
                          if(!empty($row->getRoleNames())){
                                foreach($row->getRoleNames() as $v){
                                    return ' <label class="badge badge-success">'. $v .'</label>';
                                }
                               }
                            
                       
                    })
                    ->rawColumns(["role","action"])
                    ->make(true);
            }
            $roles = Role::pluck('name','name')->all();
            return view('admin.users',compact('roles'));
         
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
       
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate(
            $request,
            [
                "user_name" => "required",
                "user_email" =>  "required|email|unique:users,email",
                "user_confim_pass" => "required",
                "user_role" => "required",
                'user_password' => 'min:6|required_with:user_confim_pass|same:user_confim_pass',
              
            ],
            [
                "user_name.required" => "User name filed is required",
                "user_email.required" => "Email Field is required",
                "user_password.required" => "Password is required",
                "user_confim_pass.required" => "Confirm password is required",
                "user_role.required" => "User rold is required",
            ]
        );

        $user = User::firstOrCreate([
            "email" => $request->user_email,
            "name"=> $request->user_name,
             "password"=>Hash::make($request->user_password)
        ]);

        $user->assignRole($request->user_role);

        if($user){
            $this->refreshCache();
            return response()->json(
                [
                    "success" => true,
                    "message" => "User Added Successfully!",
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "message" => "User Can't able to add",
                ],
                200
            );
        }

       
   
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try {
 
            $User = User::find($id);
            if (!$User) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $User],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        
        $this->validate(
            $request,
            [
                "user_name" => "required",
                "user_email" => "required|email|unique:users,email,".$id,
                "user_confim_pass" => "nullable",
                "user_role" => "required",
                'user_password' => 'nullable|min:6|required_with:user_confim_pass|same:user_confim_pass',
              
            ],
            [
                "user_name.required" => "User name filed is required",
                "user_email.required" => "Email Field is required",
                "user_password.required" => "Password is required",
                "user_confim_pass.required" => "Confirm password is required",
                "user_role.required" => "User rold is required",
            ]
        );

        $update_array=array(
            "email" => $request->user_email,
            "name"=> $request->user_name,
        );


        if(isset($request->user_password)){
           $update_array['password']=Hash::make($request->user_password);
        }

        $user = User::find($id);
        $user->update($update_array);
        
        DB::table('model_has_roles')->where('model_id',$id)->delete();
    
        $user->assignRole($request->input('user_role'));
        if($user){
            $this->refreshCache();
            return response()->json(
                [
                    "success" => true,
                    "message" => "User Updated Successfully!",
                ],
                200
            );
        }else{
            return response()->json(
                [
                    "success" => false,
                    "message" => "User Can't able to update",
                ],
                200
            );
        }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $res = User::find($id)->delete();
            $this->refreshCache();
            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Some thing went to wrong!",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "User was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }

    public function refreshCache(){
        $data = User::select('*')
        ->orderBy("id", "DESC")
        ->get();
        Cache::put('Users',$data);
    }
}
