<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Venue;
use DataTables;
use Image;
use File;
use Exception;
use Cviebrock\EloquentSluggable\Services\SlugService;
class VenueController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      
        //
        try {
            if ($request->ajax()) {
                $data = Venue::with('sports.category')->select('id','sports_category','name','image','slug','sports')->orderBy('id','DESC');
                return Datatables::of($data)->addIndexColumn()
                    ->addColumn('action', function($row){
                        $btn = '
                        <a href='.route('admin.court-time-schedule',$row->id).'>
                        <button type="button" class="btn btn-icon btn-info w-30px h-30px ms-auto" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-inverse" data-bs-placement="top" title="Schedule time">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-clock fs-3"></i>
                        </span>
                        </button></a>
                        <button type="button" class="btn btn-icon btn-primary w-30px h-30px ms-auto edit_sports" data-id="'.$row->id.'">
                        <span class="svg-icon svg-icon-3">
                        <i class="las la-pen fs-3"></i>
                        </span>
                        </button>
                        <button type="button" class="btn btn-icon btn-danger w-30px h-30px ms-auto delete_venue" data-id="'.$row->id.'" id="kt_users_delete_two_step">
                        <span class="svg-icon svg-icon-3">
                        <i class="fonticon-trash-bin fs-3 svg-icon-danger"></i>
                        </span>
                        </button>';
                        return $btn;
                    })->editColumn('image',function($row){
                        if(isset($row->image) && $row->image!='' ){
                            return asset($row->image);
                        }
                            return asset('admin/assets/media/no_img.png');
                     })->filter(function ($instance) use ($request) {
                        if($request->get('category')){
                            $cid=$request->get('category');
                          // $instance->whereHas('sports.category', $request->get('category'));
                           $instance->whereHas('sports', function($q) use  ($cid){
                            $q->where('category',$cid);
                        });
                        }
                        if($request->get('sports')){
                           $instance->where('sports', $request->get('sports'));
                        }

                        if($request->get('court')){
                            $instance->where('id', $request->get('court'));
                         }
                     
                         
                         })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            $category=Category::all();
            $sports_all=Sports::all();
            $sports=null;
            if(isset($_GET['sports_id'])){
               $sports_id=$_GET['sports_id'];
               $sports=Sports::find($sports_id);
               //echo json_encode($sports->cat->id);die;
             }
           // echo json_encode($category);
            return view('admin.venue',compact('category','sports','sports_all'));
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );
            echo $e->getMessage();
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $this->validate(
            $request,
            [
                "file" => "required|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
              
                "venue_name"=>"required",
                "sports"=>"required"
            ],
            [
                "file.required" => "You have to choose the Venue image!",
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
           
                "sports.required"=>"Type of Sports is required",
                "venue_name.required"=>"Venue name is required"
            ]
        );

        try {
            $image = $request->file("file");
            $imageName = time() . "." . $image->extension();
            $path = public_path("venue");
            if (!File::isDirectory($path)) {
                File::makeDirectory($path, 0777, true, true);
            }

            $sub_foler_arr = ["thumbnail", "images"];
            foreach ($sub_foler_arr as $_data) {
                if (!File::isDirectory($path . "/" . $_data)) {
                    File::makeDirectory($path . "/" . $_data, 0777, true, true);
                }
            }

            $destinationPathThumbnail = public_path("venue/thumbnail");
            $img = Image::make($image->path());
            $img->resize(125, 125, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPathThumbnail . "/" . $imageName);

            $destinationPath = public_path("venue/images");
            $image->move($destinationPath, $imageName);

            $flight = Venue::firstOrCreate([
                "name" => $request->venue_name,
                "sports_category" =>Sports::find($request->sports)->category,
                "sports" => $request->sports,
                "slug" => SlugService::createSlug(
                    Venue::class,
                    "slug",
                    $request->venue_name
                ),
                "image" => "venue/thumbnail/" . $imageName,
            ]);

            if ($flight) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Court added successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );

            echo $e->getMessage();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      //  try {
 
            $Venue = Venue::find($id);
            if (!$Venue) {
                return response()->json(
                    ["success" => false, "data" => ""],
                    424
                );
            }

            return response()->json(
                ["success" => true, "data" => $Venue],
                200
            );
     //   } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
      //  }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $this->validate(
            $request,
            [
                "file" => "nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048",
                "category_type" => "required",
                "venue_name"=>"required",
                "sports"=>"required"
            ],
            [
              
                "file.mimes" => "Plese upload jpeg,png,jpg,gif,svg images",
                "category_type.required" => "Category type is required",
                "sports.required"=>"Type of Sports is required",
                "venue_name.required"=>"Venue name is required"
            ]
        );

        try {
            $venues = Venue::find($id);
            //dd($venues);
            $image = $request->file("file");
            if ($image) {
                $imageName = time() . "." . $image->extension();
                $path = public_path("venue");
                if (!File::isDirectory($path)) {
                    File::makeDirectory($path, 0777, true, true);
                }

                $sub_foler_arr = ["thumbnail", "images"];
                foreach ($sub_foler_arr as $_data) {
                    if (!File::isDirectory($path . "/" . $_data)) {
                        File::makeDirectory(
                            $path . "/" . $_data,
                            0777,
                            true,
                            true
                        );
                    }
                }

                $destinationPathThumbnail = public_path("venue/thumbnail");
                $img = Image::make($image->path());
                $img->resize(125, 125, function ($constraint) {
                    $constraint->aspectRatio();
                })->save($destinationPathThumbnail . "/" . $imageName);

                $destinationPath = public_path("venue/images");
                $image->move($destinationPath, $imageName);
                $filename = "venue/thumbnail/" . $imageName;
            } else {
                $filename = $venues->image;
            }

            $venues->name = $request->venue_name;
            $venues->sports_category = $request->category_type;
            $venues->sports = $request->sports;
            $venues->slug = SlugService::createSlug(
                Venue::class,
                "slug",
                $request->venue_name
            );
            $venues->image = $filename;
            $res = $venues->save();
            if ($res) {
                return response()->json(
                    [
                        "success" => true,
                        "message" => "Court Updated successfully",
                    ],
                    200
                );
            }
        } catch (Exception $e) {
            // return response()->json(
            //     [
            //         "success" => false,
            //         "message" => "Some issue.Please contact admin",
            //     ],
            //     204
            // );  
            echo $e->getMessage();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        try {
            $res = Venue::find($id)->delete();

            if (!$res) {
                return response()->json(
                    [
                        "success" => false,
                        "message" => "Court not deleted !",
                    ],
                    424
                );
            }

            return response()->json(
                [
                    "success" => true,
                    "message" => "Court was deleted successfully!",
                ],
                200
            );
        } catch (Exception $e) {
            return response()->json(
                [
                    "success" => false,
                    "message" => "Some issue.Please contact admin",
                ],
                204
            );
        }
    }
}
