<?php
namespace App\Http\Controllers\Api;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller as Controller;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\PlayCoin;
use App\Models\Setting;
use App\Models\PlayerMembership;
class BaseController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendResponse($result, $message,$return=null)
    {
    	$response = [
            'success' => true,
            'authentication'=>auth('sanctum')->check(),
            'data'    => $result,
            'message' => $message,
            'return_data' =>$return,
        ];
        return response()->json($response, 200);
    }


    /**
     * return error response.
     *
     * @return \Illuminate\Http\Response
     */
    public function sendError($error, $errorMessages = [],$return=null )
    {
    	$response = [
            'success' => false,
            'authentication'=>auth('sanctum')->check(),
            'message' => $error,
        ];


        if(!empty($errorMessages)){
            $response['data'] = $errorMessages;
        }


        return response()->json($response, 400);
    }
    public function LoadSlotDates(){
        $today=Carbon::now()->format('Y-m-d');
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(7));
        $dates = $dateRange->toArray();
        $modified_dates = array();
        foreach ($dates as $date) {
            $modified_dates[] = $date->format('Y-m-d');
        }
        Cache::put('slot_date',$today);
        Cache::put('slot_dates',$modified_dates);
    }
    public function LoadBookingtDates(){
        $today=Carbon::now()->format('Y-m-d');
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(7));
        $dates = $dateRange->toArray();
        $modified_dates = array();
        foreach ($dates as $date) {
            $modified_dates[] = $date->format('Y-m-d');
        }
        Cache::put('booking_date',$today);
        Cache::put('booking_dates',$modified_dates);
    }

    public function basicUserData(Request $request){
        $id =  $request->user()->id;
        $data=[];
        $playcoin=PlayCoin::select('avail_coins')->where('player_id',$id)->first();
        $data['avail_coins']=isset($playcoin->avail_coins) ? $playcoin->avail_coins  : 0 ;
        $setting=Setting::select('value')->where('key','playcoin_max_usage')->first();
        $data['max_coin_use']=(int)$setting->value;
        $membership=PlayerMembership::with(['package'=> function ($query) {
            $query->select('id', 'discount');
        }])->select('start_date','end_date','status','id','pack_id')->where('player_id',$id)->first();
        ($membership==null)   ? $data['membership']=[]  :  $data['membership'][]= $membership ;
        return $data;
    }
    public function isMembershipActive(Request $request){
        $id =  $request->user()->id;
        $status='';
        $membership=PlayerMembership::with(['package'=> function ($query) {
            $query->select('id', 'discount');
        }])->select('start_date','end_date','status','id','pack_id')->where('player_id',$id)->first();
        ($membership==null)   ? $status=false :  $status=true ;
        return $status;
    }
  
}
