<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Api\BaseController as BaseController;
use Illuminate\Http\Request;
use App\Models\Slots;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\Booking;
use App\Models\BookingSlots;
use App\Models\BookingSlotHistory;
use App\Models\CutomSlots;
use App\Models\CutomSlotsTiming;
use App\Models\CoachingTimings;
use App\Models\CarbonImmutable;
use App\Models\Venue;
use App\Models\SlotTime;
use App\Models\PlayCoin;
use App\Models\Customer;
use App\Models\PlayCoinHistory;
use App\Models\Setting;
use App\Models\Sports;
use Razorpay\Api\Api;
use Cache;
use Validator;
use App\Jobs\SlotBookingQueue;
use App\Jobs\NotificationQueue;
class BookingController extends BaseController
{
    public function loadDateAndSlots($cid=null,$did=null){
        $slots=Slots::with('slotTime')->get();
            if(!$did){
            if(Cache::get('date')!=Carbon::now()->format('Y-m-d')){
                $this->LoadDates();
            }
            if(!Cache::get('dates')){
                $this->LoadDates();
            }
            else
               // echo "else";
                $dates=Cache::get('dates');
                echo json_encode($dates);
                //Cache::forget('dates');
                die;
           
            $weekday=($dates[0]->weekDay());
            $slots=BookingSlots::rightJoin('slots_timing','slots_timing.id','=','booking_slots.slot_id')->where('slots_timing.day_id',$weekday)->where('slots_timing.court_id',$cid)
            ->orderBy('slots_timing.id','ASC')
            ->get();
            echo json_encode($slots);
            }   
    }

    public function LoadDates(){
        $today=Carbon::now()->format('Y-m-d');
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(60));
        $dates = $dateRange->toArray();
        $modified_dates = array();
        foreach ($dates as $date) {
            $modified_dates[] = $date->format('Y-m-d');
        }
        Cache::put('date',$today);
        Cache::put('dates',$modified_dates);
    }

    public function loadBooking($id){
        $today=Carbon::now()->format('Y-m-d');
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(20));
        $modified_dates['dates'] = array();
        foreach ($dateRange as $date) {
            $modified_dates['dates'][] = $date->format('d-m-Y');
        }
       if($modified_dates){
            $return_data=array('sports_id'=>$id);
            return $this->sendResponse($modified_dates, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
       
    }

    public function loadBookingCourts($sid,$did){
        $success['court']=Venue::where(['sports'=>$sid])->get();
        if($success){
            $return_data=array('sports_id'=>$sid,'date'=>$did);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadBookingCourtsTime($sid,$did,$cid,Request $request){
        $date=date("Y-m-d", strtotime($did));
        $membership=$this->isMembershipActive($request);
        $CutomSlotsCollection=CutomSlots::where(['court_id'=>$cid,'date'=>$date])->get();
        if($CutomSlotsCollection->count()>0){
            $success['slots']=BookingSlots::rightJoin('custom_slots_timing','custom_slots_timing.id','=','booking_slots.cus_slot_id')
            ->where('custom_slots_timing.day_date',$date)->where('custom_slots_timing.court_id',$cid)
            ->orderBy('custom_slots_timing.id','ASC')
            ->get();
        }
        else{
            $en = Carbon::parse($date);
            $weekday=$en->weekDay();
            $success_slots=BookingSlots::
            rightJoin("slots_timing",function($join) use ($date){
                $join->on('slots_timing.id','=','booking_slots.slot_id')
                ->whereDate('booking_slots.booking_date', '=', $date);
            })
            ->where('slots_timing.day_id',$weekday)
            ->where('slots_timing.court_id',$cid)
            ->orderBy('slots_timing.id','ASC');
            if($date == carbon::today()->format('Y-m-d')){
             $success_slots->where('time_from','>=',date('H:i:s'));
            }
              $success['slots']=$success_slots->get();

         }
         $sports=Sports::find($sid);
         $success['sports_type']=$sports->type;
        if($success){
            $sports=Sports::find($sid);
            $return_data=array('sports_id'=>$sid,'date'=>$did,'court_id'=>$cid);
            $return_data['play_coin']=$this->basicUserData($request);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function slotBook(Request $request){
       
        
               $validator = Validator::make($request->all(), [
                    'sport_id' => 'required',
                    'date' => 'required',
                    'court_id' => 'required',
                    'slot' => 'required',
                    'amount' => 'required',
                ],
                [
                    "sport_id.required" => "Plese select a sports",
                    "date.required" => "Please select a date",
                    "court_id.required" => "Please select a court",
                    "amount.required" => "Some issue. Please contact admin",
                    "slot.required" => "Please select slots"
                ]);
                if($validator->fails()){
                    $err=$validator->errors();
                    return $this->sendError($err->first(), $validator->errors());  
                }
                $id =  $request->user()->id;
               
                $use_pc=0;
                $mem_discount=0;
                //$date=date("Y-m-d", strtotime($did));
                $date=date("Y-m-d", strtotime($request->date));
                $CutomSlotsCollection=CutomSlots::where(['court_id'=>$request->court_id,'date'=>$date])->get();
                $user_data=$this->basicUserData($request);
                if($request->playcoin_used!=0){
                    ($user_data['avail_coins'] >=$user_data['max_coin_use']) ? $use_pc=$user_data['max_coin_use']  :  $use_pc=$user_data['avail_coins'] ;
                 }
                if($CutomSlotsCollection->count()>0){
                    
                    $slot_total=$this->getCustomSlotsTotal($request->slot);
                    if(isset($user_data['membership'][0]['status']) && $user_data['membership'][0]['status']=='active'){
                        $dis_per=$user_data['membership'][0]['package']['discount'];
                        $mem_discount=$slot_total * ($dis_per/100);
                    }
                    $total=$slot_total - $mem_discount - $use_pc;
                    
                    if($total!=$request->amount){
                        return $this->sendError("Amount mismatched issue",[]);
                    }
                    $booking_date=Carbon::parse($request->date)->format('Y-m-d');
                    $slot=BookingSlots::whereIn('cus_slot_id',$request->slot)
                    ->where('booking_date',$booking_date);
                    $slot_collect =clone $slot;
                    if(sizeof($slot->where('player_id','!=',$id)->get())>0){
                        return $this->sendError("Slot already book by someone",[]);
                    }
                    $temp = array(
                        'player_id' => $id,
                        'day_id' =>  '',
                        'date' =>$booking_date,
                        'sports_id'=>$request->sport_id,
                        "court_id" => $request->court_id,
                        "price" => $total,
                        'no_of_slots'=>count($request->slot),
                        "total_payload" =>json_encode(array('g_total'=>$slot_total,'discount'=> $mem_discount,'play_coin'=>$use_pc)),
                        "payment_status" => 'initiate'
                    );
                    
                    ($request->team) ? $temp['team_payload']=json_encode($request->team)  : $temp['team_payload']=json_encode([])  ; 
                    $res=Booking::insertGetId($temp);
                    $slot_collect->where('player_id','=',$id)->delete();
                    if($res){
                        foreach($request->slot as $_data){
                            $timings=CutomSlotsTiming::select('time_from','time_to')->where('id',$_data)->first();
                            $slot_temp[] = array(
                                'booking_id' => $res,
                                'slot_id' =>  '',
                                'day_id' => '',
                                'sports_id'=>$request->sport_id,
                                "cus_slot_id" => $_data,
                                "slot_status" => 'hold',
                                'court_id'=> $request->court_id,
                                "booking_date" =>$booking_date,
                                "player_id" => $id,
                                'start_time'=> date("h.i A", strtotime( $timings->time_from)),
                                'end_time'=> date("h.i A", strtotime( $timings->time_to)),
                         );
                        }
                        $bookingJobs = (new SlotBookingQueue($res))->delay(Carbon::now()->addSeconds(300));
                        dispatch($bookingJobs);
                        $slot_res=BookingSlots::insert($slot_temp);
                        if($slot_res){
                            $success['order_id']=$res;
                            $return['total']= $total;
                            return $this->sendResponse($success, "Data Retrive succesfully",$return);
                        }
                    }
                  
                }else{
     
                   // $user_data=$this->basicUserData($request);
                    $en = Carbon::parse($request->date);
                    $weekday=$en->weekDay();
                    $slot_total=$this->getSlotsTotal($request->slot);
                     if(isset($user_data['membership'][0]['status']) && $user_data['membership'][0]['status']=='active'){
                        $dis_per=isset($user_data['membership'][0]['package']['discount']) ? $user_data['membership'][0]['package']['discount'] :  0;
                        $mem_discount=$slot_total * ($dis_per/100);
                    }
                    $total=$slot_total - $mem_discount - $use_pc;
                    if(round($total)!=$request->amount){
                        return $this->sendError("Amount mismatched issue". $total,[]);
                 
                    }
                    $booking_date=Carbon::parse($request->date)->format('Y-m-d');
                    $slot=BookingSlots::whereIn('slot_id',$request->slot)
                    ->where('booking_date',$booking_date);
                    $slot_collect =clone $slot;
                    if(sizeof($slot->where('player_id','!=',$id)->get())>0){
                        return $this->sendError("Slot already book by someone",[]);
                    }
                    $temp = array(
                        'player_id' => $id,
                        'day_id' =>  $weekday,
                        'date' =>$booking_date,
                        'sports_id'=>$request->sport_id,
                        "court_id" => $request->court_id,
                        "price" => $total,
                        'no_of_slots'=>count($request->slot),
                        "total_payload" =>json_encode(array('g_total'=>$slot_total,'discount'=> round($mem_discount),'play_coin'=>$use_pc)),
                        "payment_status" => 'initiate'
                    );
                    
                    ($request->team) ? $temp['team_payload']=json_encode($request->team)  : $temp['team_payload']=json_encode([])  ; 
                    $res=Booking::insertGetId($temp);
                    $slot_collect->where('player_id','=',$id)->delete();
                    if($res){
                        foreach($request->slot as $_data){
                            $timings=SlotTime::select('time_from','time_to')->where('id',$_data)->first();
                            $slot_temp[] = array(
                                'booking_id' => $res,
                                'slot_id' =>  $_data,
                                'day_id' => $weekday,
                                'sports_id'=>$request->sport_id,
                                "cus_slot_id" => '',
                                "slot_status" => 'hold',
                                'court_id'=> $request->court_id,
                                "booking_date" =>$booking_date,
                                "player_id" => $id,
                                'start_time'=> date("h.i A", strtotime( $timings->time_from)),
                                'end_time'=> date("h.i A", strtotime( $timings->time_to)),
                         );
                        }
                        $bookingJobs = (new SlotBookingQueue($res))->delay(Carbon::now()->addSeconds(300));
                        dispatch($bookingJobs);
                        $slot_res=BookingSlots::insert($slot_temp);
                        if($slot_res){
                            $success['order_id']=$res;
                            $return['total']= $total;
                            return $this->sendResponse($success, "Data Retrive succesfully",$return);
                        }
                    }
                }
      }

    public function getSlotsTotal($slots){
         return SlotTime::whereIn('id',$slots)->get()->sum('price');
    }
    public function getCustomSlotsTotal($slots){
        return CutomSlotsTiming::whereIn('id',$slots)->sum('price');
   }
   
    public function slotBookUpdate(Request $request){
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'status' => 'required',
            'remarks' => 'required',
            'player_id'=>'required'
        ],
        [
            "order_id.required" => "Order id missing",
            "status.required" => "status missing",
            "remarks.required" => "Remark missing",
            "player_id.required" => "Player id missing",
        ]);
       
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        if($id!=$request->player_id){
            return $this->sendError([],"Session Expired . Please logout & login again");
        }

        $Booking=Booking::find($request->order_id);
        if($Booking){
            $Booking->payment_status=$request->status;
            $Booking->remarks=$request->remarks;
            $data=$Booking->save();
            if($data){
            BookingSlots::where('booking_id',$request->order_id)->update([
                'slot_status'=> ($request->status=='success') ? 'booked' : 'hold'
            ]);
            $amount=0;
            if($request->status=='success'){
               $amount= $this->updatePlayCoins($request,$Booking);
                $this->releaseReferalAmount($request);
                $success['cashback']=$amount;
                $this->updateSlotBookingHistory($Booking,$request);
                $NotiJobs = (new NotificationQueue($id,'Playcoin','You got '.$amount.' playcoins for previous booking'))->delay(Carbon::now()->addSeconds(300));
                dispatch($NotiJobs);
            }
           
            //$msg=($request->status=='success') ? 'Your  slot successfully booked': 'Your slot boooking failed' ; 
            if($request->status=='success'){
                $msg='Your  slot successfully booked';
                //storeNotification($id,'Success','Your slot successfully booked');
                $NotiJobs = (new NotificationQueue($id,'Success','Your slot successfully booked'))->delay(Carbon::now()->addSeconds(100));
                dispatch($NotiJobs);
                return $this->sendResponse($success, $msg,$return_data=[]);
            }else{
                BookingSlots::where('booking_id',$request->order_id)->where('slot_status','hold')->delete();
                $msg='Your slot boooking failed';
                //storeNotification($id,'Failed','Your slot boooking failed');
                $NotiJobs = (new NotificationQueue($id,'Failed','Your slot boooking failed'))->delay(Carbon::now()->addSeconds(100));
                dispatch($NotiJobs);
                return $this->sendError($msg,$msg,$return_data=[]);
            }
        }
        }else{
            BookingSlots::where('booking_id',$request->order_id)->where('slot_status','hold')->delete();
            return $this->sendError('Slot can\'t able to book right now . Kindly contact support', []); 
        }
       BookingSlots::where('booking_id',$request->order_id)->where('slot_status','hold')->delete();
        return $this->sendError('Slot can\'t able to book right now . Kindly contact support', []);  

    }
    public function updateSlotBookingHistory($data,$request){
        $id =  $request->user()->id;
        $timings=BookingSlots::select('id','start_time','end_time')
        ->where('booking_id',$data->id)->get()->toArray();
        $temp[]=array(
            'player_id'=> $id, 
            'date'=>$data->date , 
            'sports'=>$data->sportsName->name ?? '', 
            'court'=>$data->courtName->name ?? '', 
            'request_payload'=>json_encode(array('sport'=>$data->sports_id,'court'=>$data->court_id)),
            'timings'=> json_encode($timings), 
            'total_payload'=> json_encode($data->total_payload), 
            'team_payload'=> json_encode($data->team_payload), 
            'payment_status'=> $data->payment_status, 
            'booking_status'=> ($data->payment_status=='success') ? 'confirmed'  : 'failed' , 
            'booking_id'=> $data->id, 
            'price'=>$data->price,
            'payment_id'=>$data->remarks
        );
        
        BookingSlotHistory::insert($temp);
       
    }
    public function slotBookingHistory(Request $request){
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'player_id' => 'required',
        ],
        [
            "player_id.required" => "Player id missing",
        ]);

        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        if($id!=$request->player_id){
            return $this->sendError([],"Session Expired . Please logout & login again");
        }
        $success['slot_history']=BookingSlotHistory::where(['player_id'=>$id])->orderBy('date','DESC')->get();
         
        // $success['slot_history']=Booking::with(['sport:id,name','court:id,name','slots:id,start_time,end_time,booking_id'])->where(['player_id'=>$id,'payment_status'=>'success'])->orderBy('date','DESC')->get();
        // //dd($book_data);
         return $this->sendResponse($success,'',$return_data=[]);



    }

    public function updatePlayCoins($request,$data){
       //echo json_encode($data);
       $id =  $request->user()->id;
       $coin_collect=PlayCoin::where('player_id',$id);
       $cc_clone=clone $coin_collect;
       $cc_clone_inc=clone $coin_collect;
       $cc_clone_get_data=clone $coin_collect;
       $coin_collect_insert=clone $coin_collect;
      // $data->sportsName;
       // $data->courtName;
      
       if($data->total_payload['play_coin']>0){
        $remain_coins=tap($coin_collect->decrement('avail_coins', $data->total_payload['play_coin']));
        $this->updatePlayCoinHistory($id,'debit',$data->total_payload['play_coin'],$data->sportsName->name."-".$data->courtName->name,isset($cc_clone->first()->avail_coins) ? $cc_clone->first()->avail_coins :  0 );
       }
       $setting=Setting::select('value')->where('key','playcoin_cashback')->first();
       if($setting->value>0){
          $amount=round($data->price * ($setting->value/100),0);
          
          
          $remain_coins=$coin_collect->updateOrCreate(['player_id'=>$id],[
            'player_id' => $id,
            'avail_coins' => 0
          ])->increment('avail_coins', $amount);

        $this->updatePlayCoinHistory($id,'debit',$data->total_payload['play_coin'],isset($data->sportsName->name)."-".isset($data->courtName->name),isset($cc_clone->first()->avail_coins) ? $cc_clone->first()->avail_coins :  0 );
          return $amount;
       }
    }


    public function updatePlayCoinHistory($player_id,$status,$amount,$remarks,$avail){
        $temp=array(
            'players_id'=> $player_id, 
            'coins'=>$amount , 
            'type'=> $status, 
            'balance'=> $avail, 
            'remarks'=> $remarks
        );
       PlayCoinHistory::insert($temp);
    }

    public function slotCancel(Request $request){
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'player_id'=>'required'
        ],
        [
            "order_id.required" => "Order id missing",
            "player_id.required" => "Player id missing",
        ]);
       
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $booking=Booking::find($request->order_id);
        if($booking){
           $price=$booking->price;
          // $payment_id=$booking->remarks;
           $payment_id="pay_KdYEqnzLmWxtcK";
           $booking->delete();
           BookingSlots::where('booking_id',$request->order_id)->delete();
           $success=BookingSlotHistory::where('booking_id',$request->order_id)
           ->update(['booking_status'=>'canceled']);

           //$api = new Api(env('RAZORPAY_KEY'), env('RAZORPAY_SECRET'));

           //$api->payment->fetch($payment_id)->refund(array("amount"=> $price, "speed"=>"optimum", "notes"=>array("notes_key_1"=>$request->order_id , "notes_key_2"=>$price."refuned"), "receipt"=>"Receipt No. 31"));

           if($success){
                storeNotification($id,'Canceled','Slot canceled successfully');
                return $this->sendResponse($success, "Slot canceled successfully",$return_data=[]);
           }
           return $this->sendError([],"Somthig went to wrong");

        }

        
    }

    public function releaseReferalAmount($request){
        $user=($request->user());
        if($user->used_referal!='yes' && $user->from_referal !=""){
           $setting=Setting::select('key','value');
           $setting1=clone  $setting;
           $set_from=$setting->where('key','referal_sender')->first();
           $set_to=$setting1->where('key','referal_receiver')->first();
           $this->referalPlayCoinUpdate($request,$user->id,'Referal first book',$set_from->value);
           $customer=Customer::where('referal_code',$user->from_referal)->select('id','name')->first();
           $this->referalPlayCoinUpdate($request,$customer->id,'Referal',$set_to->value);
           $user->used_referal='yes';
           $user->save();
        }   
   
    }

    public function referalPlayCoinUpdate($request,$player_id,$message,$amount){
           $coin_collect=PlayCoin::where('player_id',$player_id);
           $remain_coins=$coin_collect->updateOrCreate(['player_id'=>$player_id],[
             'player_id' => $player_id,
             'avail_coins' => 0
           ])->increment('avail_coins', $amount);
          $this->updatePlayCoinHistory($player_id,'credit',$amount,$message,$coin_collect->first()->avail_coins);
    }
}
