<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use File;
use Image;
use App\Models\Complaint;
use App\Models\ComplaintTypes;
use App\Http\Controllers\Api\BaseController as BaseController;
class ComplaintController extends BaseController
{
    //

    public function save(Request $request){
            $validator = Validator::make($request->all(), [
                'player_id' => 'required',
                'issue_type' => 'required',
                'description' => 'required',
            ],
            [
                "player_id.required" => "Player id missing",
                "issue_type.required" => "Issue type missing",
                "description.required" => "Product type missing"
            ]);
            if($validator->fails()){
               //if(customer::where(['mobile_number',$request->mobile_number]))
                 $err=$validator->errors();
                 return $this->sendError($err->first(), $validator->errors());       
            }
            try {
                $image = $request->file("image");
                if($image){
                    $imageName = time() . "." . $image->extension();
                    $path = public_path("complaint");
                    if (!File::isDirectory($path)) {
                        File::makeDirectory($path, 0777, true, true);
                    }
        
                    $sub_foler_arr = ["thumbnail", "images"];
                    foreach ($sub_foler_arr as $_data) {
                        if (!File::isDirectory($path . "/" . $_data)) {
                            File::makeDirectory($path . "/" . $_data, 0777, true, true);
                        }
                    }
        
                    $destinationPathThumbnail = public_path("complaint/thumbnail");
                    $img = Image::make($image->path());
                    $img->resize(250, 250, function ($constraint) {
                        $constraint->aspectRatio();
                    })->save($destinationPathThumbnail . "/" . $imageName);
        
                    $destinationPath = public_path("complaint/images");
                    $image->move($destinationPath, $imageName);
                    $filename = "complaint/thumbnail/" . $imageName;
                }else{
                    $filename="complaint/no_img.jpg";
                }
               
                $success= Complaint::insert([
                    'player_id'=> $request->player_id, 
                    'issue_type'=> $request->issue_type, 
                    'description'=> $request->description, 
                    'image'=> $filename, 
                 ]);
                 if($success){
                    return $this->sendResponse($success, "Complaint Has Been Successfully Registered",$return_data=[]);
               }
               return $this->sendError([],"Somthig went to wrong");
      
            }catch (Exception $e) {
                return $this->sendError([],"Somthig went to wrong");
            }
    }

    public function get(Request $request){
        $validator = Validator::make($request->all(), [
            'player_id' => 'required',
           
        ],
        [
            "player_id.required" => "Player id missing",
           
        ]);
        if($validator->fails()){
           //if(customer::where(['mobile_number',$request->mobile_number]))
             $err=$validator->errors();
             return $this->sendError($err->first(), $validator->errors());       
        }
        $success=Complaint::with('complainttype:id,name')->where('player_id',$request->player_id)->orderBy('id','desc')->get();
        if($success){
            return $this->sendResponse($success, "Complaint list retrive successfully",$return_data=[]);
         }
       return $this->sendError("Somthig went to wrong","Somthig went to wrong");


    }

    public function list(){
        $success=ComplaintTypes::get();
        if($success){
            return $this->sendResponse($success, "Complaint list",$return_data=[]);
         }
       return $this->sendError([],"Somthig went to wrong");
        
    }
}
