<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\BaseController as BaseController;
use Illuminate\Http\Request;
use App\Models\Slots;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\BookingSlots;
use App\Models\SlotTime;
use App\Models\CouchingBooking;
use App\Models\Coaching;
use App\Models\CoachingTimings;
use App\Models\CoachingHistory;
use Cache;
use Illuminate\Database\Eloquent\Builder;
use App\Jobs\BookCoachQueue;
use Laravel\Sanctum\PersonalAccessToken;
use Log;
use Validator;
class CouchingController extends BaseController
{

    

    //
    public function LoadDates(Request $request){

    }

    public function loadCouch($id){
        $couching=Coaching::with(['weekday'])->where('court_id',$id)->get();
        echo json_encode($couching);
    }

    public function index($id){
        $customer_type=config('enums.ctype');
        $customer_level=config('enums.clevel');
        $success=array('cus_type'=>$customer_type,'cus_level'=>$customer_level);
        if($success){
            $return_data=array('sports_id'=>$id);
            return $this->sendResponse($success, "Data Retrive succesfully", $return_data);
           
        }
        return $this->sendError([],"Somthig went to wrong");
        
    }

    public function loadCouchingCourt($id,$cat=null,$level=null){
        $success['coaching_courts']=CoachingTimings::with('court')->whereHas('court', function($q)use($id){
            $q->where('sports', '=',$id);
         })->select('court_id')->where(['customer_type'=>$cat,'customer_level'=>$level])->groupby('court_id')->distinct()->get();
         if($success){
            $return_data=array('sports_id'=>$id,'cus_category'=>$cat,'cus_level'=>$level);
            return $this->sendResponse($success, "Data Retrive succesfully", $return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadCouchingCourtSession($id,$cat=null,$level=null,$cid){
        $success['coaching_sessions']=Coaching::with(['weekday'])->where('court_id',$cid)->get();
        if($success){
            $return_data=array('sports_id'=>$id,'cus_category'=>$cat,'cus_level'=>$level,'court_id'=>$cid);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadCouchingSlotDate($id,$cat=null,$level=null,$cid=null,$session_id){
        $today=Carbon::tomorrow()->format('Y-m-d');
        $data=Coaching::with('Timings')->where(['id'=>$session_id])->first();
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(28))->filter(
            fn ($date) => in_array($date->dayOfWeek,$data->weekid),
        );
        $dates = $dateRange->toArray();
        $success = array('date'=>$dates[0]->format('Y-m-d'));
        if($success){
            $return_data=array('sports_id'=>$id,'cus_category'=>$cat,'cus_level'=>$level,'court_id'=>$cid,'session_id'=>$session_id);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadCouchingSlotTimings($id,$cat=null,$level=null,$cid=null,$session_id=null,$date){
        $success['coaching_timings']=CoachingTimings::select('*')->withCount(['booking' => function (Builder $query) use ($date){
            $query->where('ending_date', '>=', $date);
          
        }])->where(['cs_id'=>$session_id,'customer_type'=>$cat, 'customer_level'=>$level,'court_id'=>$cid])->get();
        if($success){
            $return_data=array('sports_id'=>$id,'cus_category'=>$cat,'cus_level'=>$level,'court_id'=>$cid,'session_id'=>$session_id,'date'=>$date);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadCouchingSlotTimeSelect($id,$cat=null,$level=null,$cid=null,$session_id=null,$date=null,$time){
        $data=Coaching::with('Timings')->where(['id'=>$session_id])->first();
        $time=CoachingTimings::where('id',$time)->first();
        $success['coaching_dates']=($this->loadWeekdayDates($date,30,$data->weekid,$time->start_time,$time->end_time));
        if($success){
            $return_data=array('sports_id'=>$id,'cus_category'=>$cat,'cus_level'=>$level,'court_id'=>$cid,'session_id'=>$session_id,'date'=>$date,'time'=>$time);
            return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
        }
        return $this->sendError([],"Somthig went to wrong");
    }

    public function loadWeekdayDates($from_date,$interval=30,$session,$stime=null,$etime=null){
        $dateRange = CarbonPeriod::create($from_date, Carbon::create($from_date)->addDays($interval))->filter(
            fn ($date) => in_array($date->dayOfWeek, $session),
        );
        $dates = $dateRange->toArray();
        $modified_dates = array();
        foreach ($dates as $date) {
            $modified_dates[] = array('date'=>$date->format('Y-m-d'),'from_time'=>date("h.i A", strtotime($stime)),'to_time'=>date("h.i A", strtotime($etime)));
        }
       return ($modified_dates);
    }

    public function coachingBook(Request $request){
      
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'sports_id' => 'required',
            'court_id'=>'required',
            'slot_id'=>'required',
            'session_id'=>'required',
            'date'=>'required',
            'payment_status'=>'initiate',
            'slot_status'=>'hold',
            'player_id'=>'required'
         ],
        [
            "sports_id.required" => "Sports id missing",
            "court_id" => "Court id missing",
            "slot_id" => "Slot id missing",
            "session_id" => "Session id Empty"
        ]);

        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $return_date=$this->getStartAndEndDates($request->date,$request->session_id);
        $fdate=current($return_date)->format('Y-m-d');
        $edate=end($return_date)->format('Y-m-d');
        $date=$request->date;
        $data=CoachingTimings::select('*')->withCount(['booking' => function (Builder $query) use ($date){
            $query->where('ending_date', '>=', $date);
          
        }])->where(['id'=>$request->slot_id])->first();
       // echo json_encode($data);
      //  die;
        if($data->available > 0 && ($data->amount==$request->amount)){
            if($request->player_id==$id){
               $temp = array(
                    'player_id' => $id,
                    'sports_id' => $request->sports_id,
                    "court_id" => $request->court_id,
                    "cst_id" => $request->slot_id,
                    "session_id"=>$request->session_id,
                    "join_date" => $fdate,
                    "ending_date" => $edate,
                    "amount" =>  $data->amount,
                    "date" => $request->date,
                    "payment_status"=>'initiate' , 
                    "slot_status"=> 'hold', 
                );
               $res=CouchingBooking::insertGetId($temp);
               if($res){
                $success=array('order_id'=>$res);
                $bookingJobs = (new BookCoachQueue($res))->delay(Carbon::now()->addSeconds(300));
                dispatch($bookingJobs);
                $return_data=array('sports_id'=>$request->sports_id,'court_id'=>$request->court_id,'slot_id'=>$request->slot_id,'session_id'=>$request->session_id,'date'=>$request->date);
                return $this->sendResponse($success, "Data Retrive succesfully",$return_data);
             }
        
               
            }else{
                return $this->sendError('Authendication errors', []);  
            }
        }else{
            return $this->sendError('Slot booking is closed', []);  
        }
       
       
    }

    public function getStartAndEndDates($date,$session_id){
        $today=Carbon::tomorrow()->format('Y-m-d');
        $from_date=new Carbon($date);
        $to_date=new Carbon($date);
        //return $from_date;
        $data=Coaching::with('Timings')->where(['id'=>$session_id])->first();
        $dateRange = CarbonPeriod::create($to_date->format('Y-m-d'), $from_date->addDays(28)->format('Y-m-d'))->filter(
            fn ($date) => in_array($date->dayOfWeek,$data->weekid),
        );
        $dates = ($dateRange->toArray());
        return ($dates);
       // $success = array('date'=>$dates[0]->format('Y-m-d'));
    }

    public function coachingBookUpdate(Request $request){
        // echo json_encode($request->all());
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'status' => 'required',
            'remarks' => 'required',
        ],
        [
            "order_id.required" => "Order id missing",
            "status.required" => "status missing",
            "remarks.required" => "Remark missing"
        ]);

        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $CouchingBooking=CouchingBooking::find($request->order_id);
        if($CouchingBooking){
            $CouchingBooking->payment_status=$request->status;
            $CouchingBooking->slot_status=($request->status=='success') ? 'booked' : 'hold';
            $CouchingBooking->remarks=$request->remarks;
            $data=$CouchingBooking->save();
            if($data){
            $msg=($request->status=='success') ? 'Your coaching slot successfully booked': 'Your slot boooking failed' ; 
            if($request->status=='success'){
                $this->updateCoachingHistory($CouchingBooking,$request);
                return $this->sendResponse($success=[],$msg,$return_data=[]);
            }else{
                CouchingBooking::where(['id'=>$request->order_id])->delete();
                return $this->sendError('Your slot canceled successfully', []); 
            }
          
           
            }
        }else{
            return $this->sendError('Slot cant able to book right now . Kindly contact support', []); 
        }
       
        return $this->sendError('Slot cant able to book right now . Kindly contact support', []);  
    }

    public function listCoachingBookHistory (Request $request){
        $id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'player_id' => 'required',
         ],
         [
                "player_id.required" => "Player id missing",
         ]);

        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $success['history']=CouchingBooking::select('id','join_date','ending_date','amount','payment_status','slot_status')
        ->with('CoachingHistory:id,booking_id,response_payload')
        ->where(['payment_status'=>'success','player_id'=>$id])->get();
        if($success){
            return $this->sendResponse($success,'Data Retrived successfully',$return_data=[]);
        }
        return $this->sendError('Slot cant able to book right now . Kindly contact support', []);  
    }

    public function updateCoachingHistory($data,$request){
          $id =  $request->user()->id;
          $join_date=$data->join_date;
          $dates=$this->getStartAndEndDates($join_date,$data->session_id);
          foreach ($dates as $date) {
            $modified_dates[] = $date->format('Y-m-d');
          }
          $response_payload=array(
                'sport_name'=>$data->sportsName->name,
                'court_name'=>$data->courtName->name,
                'session_name'=>$data->SessionName->group,
                'start_date'=> $data->Timings->start_time,
                'end_date'=> $data->Timings->end_time,
                'timings'=>$data->Timings->start_time_12_format."-".$data->Timings->end_time_12_format,
                'payment_status'=>$data->payment_status,
                'remarks'=>$data->remarks,
                'dates'=>$modified_dates
          );
          CoachingHistory::create([
            'player_id'=> $id,
            'sports_id'=>$data->sports_id,
            'booking_id'=>$data->id,
            'court_id'=>$data->court_id,
            'cst_id'=>$data->cst_id,
            'join_date'=>$data->join_date,
            'ending_date'=>$data->ending_date,
            'amount'=>$data->amount,
            'payment_status'=>$data->payment_status,
            'slot_status'=>$data->slot_status,
            'response_payload'=>json_encode($response_payload),
        ]);
         // echo json_encode($modified_dates);
    }
}
