<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sports;
use App\Models\Venue;
use App\Models\Tournament;
use App\Models\Banner;
use App\Models\Membership\MembershipPackage;
use App\Models\BookingSlotHistory;
use App\Models\Notification;
use App\Models\DeviceId;
use Carbon\Carbon;
use App\Http\Controllers\Api\BaseController as BaseController;
class HomeController extends BaseController
{
    
    public function index(Request $request){
        $id=$request->user()->id;
        $data['Sports'] = Sports::withCount('booking')->orderByDesc('booking_count')->take(5)->get();
        $data['Venue'] =Venue::with('sports:id,name,image,image_json')->withCount('booking')->orderByDesc('booking_count')->take(5)->get();
        $data['Tournament'] = Tournament::select('id','date','time','images','name','description')->where('status',1)->whereDate('date','>=',Carbon::today())->orderByDesc('id')->take(3)->get();
        $data['Membership'] =MembershipPackage::select('id','dur_id','plan_id','discount','price','image_json','membership_description')->with(['plan:id,plan_name','duration:id,dur_name,no_of_month'])->get();
        $data['user']=$request->user()->select('id','name','mobile','photo')->where('id',$request->user()->id)->first();
        $data['slot_history']=BookingSlotHistory::where(['player_id'=>$id,'payment_status'=>'success'])->orderBy('date','DESC')->get();
        $data['Banner']=Banner::where('status','Active')->get();
        $response = DeviceId::updateOrCreate(
            ['device_id'=>$request->device_id,'user_id'=>$id],
            ['device_id'=>$request->device_id,'user_id'=>$id]
        );
        if($data){
            return $this->sendResponse($data, "Data Retrive succesfully", $return_data=[]);
         }
        
        return $this->sendError([],"Somthig went to wrong");

    }


   

}
