<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Api\BaseController as BaseController;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Membership\MembershipDuration;
use App\Models\Membership\MembershipPackage;
use App\Models\Membership\MembershipPlans;
use App\Models\PlayerMembershipHistory;
use App\Models\PlayerMembership;
use Validator;
use Carbon\Carbon;
class MembershipPackageController extends BaseController
{
    //

    public function getPackages(Request $request){
        $id=$request->user()->id;
        $success['packages']=MembershipPackage::select('id','dur_id','plan_id','discount','price','image_json','membership_description')->with(['plan:id,plan_name','duration:id,dur_name,no_of_month'])->get();
        $membership=PlayerMembership::with(['package'=> function ($query) {
            $query->select('id', 'discount','dur_id','plan_id');
        }])->select('start_date','end_date','status','id','pack_id')->where('player_id',$id)->first();
        ($membership==null)   ? $success['membership']=[]  :  $success['membership'][]= $membership ;
        if($success){
          //  echo json_encode($membership->package);die;
       $success['duration']=(isset($membership->package->duration->dur_name)) ? $membership->package->duration->dur_name : ''  ; 
       $success['plan']=(isset($membership->package->plan->plan_name)) ? $membership->package->plan->plan_name : ''  ; 
        return $this->sendResponse($success, "Data Retrive succesfully", $return_data=[]);
       
    }
    return $this->sendError([],"Somthig went to wrong");
    }

    public function purchaseMembership(Request $request){
        $validator = Validator::make($request->all(), [
            'player_id' => 'required',
            'package_id' => 'required'
        ],
        [
            "player_id.required" => "Player is missing",
            "package_id.required" => "Please select a date"
        ]);
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $id =  $request->user()->id;
        $package=MembershipPackage::find($request->package_id);
        
        $temp=array(
            'player_id'=>$id,
            'package'=>$request->package_id,
            'plan'=>$package->plan_id,
            'duration'=>$package->dur_id ,
            'amount'=>$package->price,
            'purchase_date'=>Carbon::now()->format('d-m-Y'),
            'payment_status'=>'initate',
            'no_months'=>$package->duration->no_of_month, 
            'discount_per'=>$package->discount, 
            'request_payload'=>json_encode(array('package'=>$package->duration->dur_name,'plan'=>$package->plan->plan_name,'dis_per'=>$package->dis_per,'amount'=>$package->amount))
        );
      // echo json_encode($temp);
       $res=PlayerMembershipHistory::insertGetId($temp);
       if($res){
            $success['order_id']=$res;
            $return['package_id']=$request->package_id;
            return $this->sendResponse($success, "Data Retrive succesfully",$return);
       }
       
       return $this->sendError([],"You cant buy membership right now please contact admin");
       
    }

    public function purchaseMembershipUpdate(Request $request){
        $p_id =  $request->user()->id;
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'player_id' => 'required',
            'pay_status'=>'required',
            'remarks'=>'required'
        ],
        [
            "player_id.required" => "Player is missing",
            "order_id.required" => "Order id required",
            "pay_status.required" => "Paymenet Status required",
            "remarks.required" => "Remark is required",
        ]);
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        if($request->pay_status){
            $response=PlayerMembershipHistory::find($request->order_id);
            if($response){
                $response->payment_status=$request->pay_status;
            $ret_data=$response->update();
            if($ret_data && $request->pay_status=='success'){
                $start_date = Carbon::parse($response->purchase_date)->format('Y-m-d');
                $end_date=  Carbon::parse($response->purchase_date)->addMonths($response->no_months)->format('Y-m-d');
                $temp=array(
                    'pack_id'=>$response->package,
                    'start_date'=>$start_date,
                    'end_date'=>$end_date,
                    'player_id'=>$p_id ,
                    'dis_per'=>$response->discount_per,
                    'status'=> ($request->pay_status=='success') ? 1  : 0  ,
                    'amount'=>$response->amount
                );
               // $res=PlayerMembership::insertGetId($temp);
                $res = PlayerMembership::updateOrCreate(
                    ['player_id' => $p_id],
                    $temp
                );
                
                $success['order_id']=$res;
                $return['package_id']=[];
                return $this->sendResponse($success, "Membership Purchased Successfully",$return);
            }
            return $this->sendError("Your Payment failed ","You cant buy membership right now please contact admin");
         }
            return $this->sendError("You cant buy membership right now please contact admin","You cant buy membership right now please contact admin");
        }   
    }
}
