<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\PlayerMembership;
use App\Models\BookingSlotHistory;
use App\Models\PlayCoin;
use App\Http\Controllers\Api\BaseController as BaseController;
use Validator;
use File;
use Image;
class ProfileController extends BaseController
{
    //
    public function index(Request $request){
        $id=$request->user()->id;
        $success['customer']=Customer::select('id','name','email','mobile','gender','photo')->where('id',$id)->get();
        $membership=PlayerMembership::with(['package'=> function ($query) {
            $query->select('id', 'discount','dur_id','plan_id');
        }])->select('start_date','end_date','status','id','pack_id')->where('player_id',$id)->first();
        ($membership==null)   ? $success['membership']=[]  :  $success['membership'][]= $membership ;
        $success['booking_count']=BookingSlotHistory::where(['booking_status'=>'confirmed','player_id'=>$id])->count();
        $success['play_coin']=PlayCoin::where('player_id',$id)->get();
        if($success){
            //$return_data=array('sports_id'=>$id);
            return $this->sendResponse($success, "Data Retrive succesfully", $return_data=[]);
         
        }
        return $this->sendError([],"Somthig went to wrong");

    }
    public function update(Request $request){
        $id=$request->user()->id;
        $validator = Validator::make($request->all(), [
            'name' => 'required',
           'mobile' => 'required|numeric|unique:players,mobile,'.$id,
            //'gender' => 'required',
            //'email' => 'required',
        ],
        [
            "name.required" => "Please enter your name",
            "gender.required" => "Please select gender",
            "mobile.required" => "Please enter your mobile number",
           // "gender.required" => "Please enter your gender number",
            "mobile.numeric" => "Mobile format invalid",
           "mobile.unique" => "Your mobile number already taken",
        ]);
        if($validator->fails()){
           //if(customer::where(['mobile_number',$request->mobile_number]))
             $err=$validator->errors();
            //  if($err->first()=="Your mobile number already taken"){
            //     $cus=customer::where(['mobile'=>$request->mobile_number,'status'=>'inactive'])->first();
            //     if($cus){
            //         $request = new Request([
            //             'mobile_number'   => $request->mobile_number,
            //         ]);
            //         return $this->login($request);
            //     }
            //  }

             return $this->sendError($err->first(), $validator->errors());       
        }
        $cus=Customer::find($id);
        $cus['name']=$request->name;
        $image = $request->file("photo");
     ;
        if($image){
            $imageName = time() . "." . $image->extension();
            $path = public_path("photo");
            if (!File::isDirectory($path)) {
                File::makeDirectory($path, 0777, true, true);
            }
            $sub_foler_arr = ["thumbnail", "images"];
            foreach ($sub_foler_arr as $_data) {
                if (!File::isDirectory($path . "/" . $_data)) {
                    File::makeDirectory($path . "/" . $_data, 0777, true, true);
                }
            }
            $destinationPathThumbnail = public_path("photo/thumbnail");
            $img = Image::make($image->path());
            $img->resize(125, 125, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPathThumbnail . "/" . $imageName);
    
            $destinationPath = public_path("photo/images");
            $image->move($destinationPath, $imageName);
            $cus['photo']="photo/images/".$imageName;
        }else{
            $imageName="photo/images/default.jpg";
        }
       
        $res=$cus->save();
        if($res){
            return $this->sendResponse($res, "Profile updated Successfully", $return_data=[]);
          }
           return $this->sendError([],"Somthig went to wrong");


    }
}
