<?php

namespace App\Http\Controllers\Api;
   
use Illuminate\Http\Request;

use App\Models\Customer;
use Illuminate\Support\Facades\Auth;
use Validator;
use Image;  
use File;
use Str;
use App\Http\Controllers\Api\BaseController as BaseController;
use Illuminate\Support\Facades\Hash;
class RegisterController extends BaseController
{
    /**
     * Register api
     *
     * @return \Illuminate\Http\Response
     */
    public function register(Request $request)
    {

      
      $validator = Validator::make($request->all(), [
            'name' => 'required',
            'mobile_number' => 'required|numeric|unique:players,mobile',
            'gender' => 'required',
            'referal_code'=>'nullable'
        ],
        [
            "name.required" => "Please enter your name",
            "gender.required" => "Please select gender",
            "mobile_number.required" => "Please enter your mobile number",
            "mobile_number.numeric" => "Mobile format invalid",
            "mobile_number.unique" => "Your mobile number already taken",
        ]);
        if($validator->fails()){
           //if(customer::where(['mobile_number',$request->mobile_number]))
             $err=$validator->errors();
             if($err->first()=="Your mobile number already taken"){
                $cus=customer::where(['mobile'=>$request->mobile_number,'status'=>'active'])->first();
                if($cus){
                    $request = new Request([
                        'mobile_number'   => $request->mobile_number,
                    ]);
                    return $this->login($request);
                }
             }

            //  return $this->sendError($err->first(), $validator->errors());       
        }
      
        if($request->referal){
            $res=Customer::where('referal_code',$request->referal)->where('mobile','!=',$request->mobile_number,)
            ->first();
            if(!$res){
                return $this->sendError($success=[], 'Invalid referal code');
            }
        }
        try {
        
        $input = $request->all();
        $otp =$this->generateOTP();
        $input['otp']=$otp;
        $input['otp_verify'] ='initiate';
        $input['otp_time']=time();
        $input['mobile']=$request->mobile_number;
        $input['status']='inactive';
        $input['photo']='photo/thumbnail/default.jpg';
        $input['referal_code']=$this->generateReferalCode(6);
        $user = Customer::updateOrCreate(['mobile' => $request->mobile_number],$input);
        if($user){
            $success['name'] =  $user->name;
            $success['mobile'] = substr_replace($user->mobile, 'XXXX', -4);
            $success['otp'] = $otp ;
            return $this->sendResponse($success, "Hi  ".$user->name.",  Otp sent to your mobile numbercd");
         }
           $success['success'] =  false;
           $success['message'] = "we cant added new customer right now";
           return $this->sendError($success, 'User register successfully.');
        }catch (Exception $e) {

        }
    }
   
    /**
     * Login api
     *
     * @return \Illuminate\Http\Response
     */
    public function login(Request $request)
    {
      
        $request->validate([
            'mobile_number' => 'required|numeric'
        ]);
        $validator = Validator::make($request->all(), [
            'mobile_number' => 'required|numeric'
        ],
        [
            "mobile_number.required" => "Please enter mobile number",
            "mobile_number.numeric" => "Please enter valid mobile number",
        
        ]);
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());       
        }
        $customer = Customer::where('mobile', $request->mobile_number)->where('status','active')->first();
        
        if (!$customer) {
           
            return $this->sendError('This number does not exist', 'This number does not exist');
        }

        $otp =$this->generateOTP();
        $customer['otp']=$otp;
        $customer['otp_verify'] ='initiate';
        $customer['otp_time']=time();
        $customer->update();
       ($customer);
        
        if($customer){
            $success['name'] =  $customer->name;
            $success['mobile'] = substr_replace($customer->mobile, 'XXXX', -4);
            $success['otp'] = $otp ;
             return $this->sendResponse($success, "Hi  ".$customer->name.",  Otp sent to your mobile number");
        }
           $success['success'] =  false;
           $success['message'] = "we cant added new customer right now";
           return $this->sendResponse('we cant added new customer right now',$success);
    
    }

    public function generateOTP(){
        $otp = mt_rand(1000,9999);
        return $otp;
    }

    public function otpVerify(Request $request){
      
        $validator = Validator::make($request->all(), [
            'mobile_number' => 'required|numeric',
            'otp'=>'required|numeric|digits:4'
        ],
        [
            "mobile_number.required" => "Please enter mobile number",
            "mobile_number.numeric" => "Please enter valid mobile number",
            "otp.required" => "Please enter your otpr",
            "otp.numeric" => "Please enter valid otp",
            "otp.digits" => "Plese enter 4 digit otp",
        ]);
        if($validator->fails()){
            $err=$validator->errors();
            return $this->sendError($err->first(), $validator->errors());  
        }
        $user = Customer::where(['mobile' => $request->mobile_number]);
        $otp=$request->otp;
        if ($user->count() != 0) {
            $user_data = $user->first();
           // echo json_encode($user_data);
            if ($user_data) {
                if($user_data->otp != $otp) {
                    return $this->sendError("Please enter valid OTP",$success=[]);
                }
                if($user_data->otp_verify!="initiate"){
                    return $this->sendError("Your OTP invalid",$success=[]);
                }
                $otp_time = $user_data->otp_time;
                $cur_time = time();
                $minutes = ($cur_time - $otp_time) / 60;
                if ($minutes < 5) {
                    $user = Customer::find($user_data->id);
                    $token = $user->createToken('mobile', ['role:customer'])->plainTextToken;
                    $user->update(["otp_verify" => "success","status"=>'active']);
                    $success['name'] =  $user->name;
                    $success['token'] =  $token ;
                    $success['mobile_number'] =  $user->mobile ;
                    $success['player_id'] =  $user->id ;
                    return $this->sendResponse($success, "Hi  ".$user->name.", you are successfully logged in");
                } else {
                    $user->update(["otp_verify" => "expired"]);
                    return $this->sendError("Your otp expired",$success=[]);
                }
            }
        }else{
            return $this->sendError("This number does not exist",$success=[]);
        }
    }


    public function generateReferalCode($str='innoblitz')
    {
      
    
          // get random number min & max 4 digit
          $randomNumber = rand(1000, 9999);
          // get the first 4 character and trim whitespace
          $strName = trim(substr($str, 0, 4));
          // get str length
          $strLen = strlen($strName);
        
          // If str length less then 4 add missing x character by random str
          $substrName = $strLen < 4 ? $strName . Str::random(4 - $strLen) : $strName;
          // make name uppercase and concat with the random number
          $referral = strtoupper($substrName) . $randomNumber;
          
          return $referral;
    }
    
}
