<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Review;
use App\Http\Controllers\Api\BaseController as BaseController;
class ReviewController extends BaseController
{
    //
    public function getReviews($id,Request $request){
        $review=Review::with(['player:id,name','court:id,name'])->where('court_id',$id);
       
        $review_count=clone $review;
        $review_count5=clone $review;
        $review_count4=clone $review;
        $review_count3=clone $review;
        $review_count2=clone $review;
        $review_count1=clone $review;
        $avg_review=0;
        if($review_count->count('rating')>0){
            $avg_review=$review_count->sum('rating') / $review_count->count('rating');
        }
        
        $count[]= $review_count5->where('rating',5)->count();
        $count[]= $review_count4->where('rating',4)->count();
        $count[]= $review_count3->where('rating',3)->count();
        $count[]= $review_count2->where('rating',2)->count();
        $count[]= $review_count1->where('rating',1)->count();
        isset($request['limit']) ?  $limit=$request['limit']  : $limit=10   ;  
        isset($request['offset']) ?  $offset=$request['offset']  : $offset=1   ; 
        $paginator =$review->paginate($limit, ['*'], 'page', $offset);
        /*$paginator->count();*/
        $success['rating']=[
            'total_size' => $paginator->total(),
            'limit' => (integer)$limit,
            'offset' => (integer)$offset,
            'reviews' => $paginator->items(),
            'count'=>$count,
            'avg'=> $avg_review
        ];
        if($success){
            return $this->sendResponse($success, "Data Retrive succesfully", $return_data=[]);
          }
           return $this->sendError([],"Somthig went to wrong");
    }
}
