<?php
namespace App\Http\Controllers\Frontend;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slots;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use App\Models\BookingSlots;
use App\SlotTime;
class BookCourtController extends Controller
{
    //
    public function loadDateAndSlots($cid,$did=null){

        $slots=Slots::with('slotTime')->get();
        if(!$did){
        $today=Carbon::now();
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(60));
        $dates = $dateRange->toArray();
        $weekday=($dates[0]->weekDay());
        $slots=BookingSlots::rightJoin('slots_timing','slots_timing.id','=','booking_slots.slot_id')->where('slots_timing.day_id',$weekday)->where('slots_timing.court_id',$cid)
        ->orderBy('slots_timing.id','ASC')
        ->get();
        echo json_encode($slots);
    }
        
    }
}
