<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    
    use HasFactory;
    protected $table="booking";
       
    public function sport(){
        return $this->hasOne(Sports::class,'id','sports_id');
    }

    public function court(){
        return $this->hasOne(Venue::class,'id','court_id');
    }

    public function slots(){
        return $this->hasMany(BookingSlots::class,'booking_id','id');
    }
    
    public function  getTotalPayloadAttribute($value)
    {

        return json_decode($value,true);
    }
    public function sportsName(){
        return $this->belongsTo(Sports::class,'sports_id','id');
    }
    public function CourtName(){
        return $this->belongsTo(Venue::class,'court_id','id');
    }

    public function getTeamPayloadAttribute($value){
        return json_decode($value,true);
    }
}
