<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class BookingSlotHistory extends Model
{
    use HasFactory;
    protected $table="booking_slot_history";
     
    protected $attributes = ['is_cancel'];
    //Make it available in the json response
    protected $appends = ['is_cancel'];
    public function getTimingsAttribute(){
        // return json_decode('',true);
         return json_decode(($this->attributes['timings']),true);
     }
     public function getTotalPayloadAttribute(){
        // return json_decode('',true);
         return json_decode(($this->attributes['total_payload']),true);
     }

     public function getIsCancelAttribute(){
           if($this->attributes['date'] > carbon::now()){
              return true;
           }
           return false;

   }
   
   public function getTeamPayloadAttribute($value){
    return json_decode($value,true);
  }
  public function getRequestPayloadAttribute($value){
    return json_decode($value,true);
  }
  public function getRefundRemarksAttribute($value){
    return json_decode($value,true);
  }
 
  public function Player(){
    return $this->belongsTo(Customer::class,'player_id','id');
  }
}
