<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingSlots extends Model
{
    use HasFactory;
    protected $table="booking_slots";
    protected $attributes = ['start_time_12_format','end_time_12_format'];
           protected $casts = [
        'price' => 'string', 
     
    ];
    //Make it available in the json response
    protected $appends = ['start_time_12_format','end_time_12_format'];

    public function  getCusSlotIdAttribute($value)
        {
            return $value ?? '';
        }
    public function  getDayIdAttribute($value)
        {
            return $value ?? '';
        }
    public function  getBookingDateAttribute($value)
        {
            return $value ?? '';
        }
    public function  getSlotStatusAttribute($value)
        {

            return $value ?? 'open';
        }
        
    public function getStartTime12FormatAttribute(){
            return date("h.i A", strtotime($this->time_from));
        }

    public function getEndTime12FormatAttribute(){
            return date("h.i A", strtotime($this->time_to));
        }
    
    public function slotDetails(){
            return $this->belongsTo(SlotTime::class,'slot_id','id');
        }
    public function getPriceAttribute(){
        
         if(isMembershipActive(auth('sanctum')->user()->id) && $this->attributes['golden_hour']!=0){
            return (string)$this->attributes['golden_price'];
         }else{
            return (string)$this->attributes['price'];
            
         }
      
    }

}
