<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
class Coaching extends Model
{
    use HasFactory;
    use \Staudenmeir\EloquentJsonRelations\HasJsonRelationships;
    Protected $table='coaching_schedule';
  
    protected $casts = [
        'weekid' => 'json',
        'amount'=>'string',
       
    ];
    
    protected $attributes = ['couching_start'=>false];
    // protected $attributes = [
    //     'couching_start' => false,
    // ];
    //Make it available in the json response
      //protected $appends=['couching_start'];

    // protected $guarded = [
    //     'couching_start'
    // ];
    // protected $hidden = [
    //     'couching_start'
    // ];
    protected $fillable = [
        'group', 'weekid', 'court_id'
    ];
    public function __construct($attributes = []){
        parent::__construct($attributes);
     
      }
  
    public function weekday()
    {
        $data= $this->belongsToJson(Days::class, 'weekid')->select('id','name');
        return  $data;
    }
    
    // public function getWeekdayAttribute() {
    //     return isset($this->weekdayRelationship->name) ? $this->weekdayRelationship->name : '' ;
    // }
    
    // public function setWeekdayAttribute($value) {
    //     $this->weekdayRelationship->name= $value;
    // }

    public function Timings(){
        return $this->hasMany(CoachingTimings::class,'cs_id','id');
    }

    public function getCouchingStartAttribute(){
        $today=Carbon::tomorrow()->format('Y-m-d');
        $dateRange = CarbonPeriod::create($today, Carbon::now()->addDays(28))->filter(
            fn ($date) => in_array($date->dayOfWeek,$this->weekid),
        );
        $dates = $dateRange->toArray();
        $success = array('date'=>$dates[0]->format('Y-m-d'));
        return $success;
    }

   

}
