<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CoachingHistory extends Model
{
    use HasFactory;
    Protected $table='couching_booking_history';

   protected $casts = [
        'amount' => 'string', 
     
    ];
          
    protected $fillable=[ 'player_id',
    'sports_id',
    'court_id',
    'cst_id',
    'join_date',
    'ending_date',
    'amount',
    'payment_status',
    'slot_status',
    'response_payload',
    'booking_id'
];
   

public function getResponsePayloadAttribute(){
   // return json_decode('',true);
    return json_decode(($this->attributes['response_payload']),true);
}

}
