<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CoachingTimings extends Model
{
    use HasFactory;
    Protected $table='coaching_timing_schedule';
        protected $casts = [
     
        'amount'=>'string',
       
    ];
    //Add extra attribute
    protected $attributes = ['available','slot_status','start_time_12_format','end_time_12_format'];

    //Make it available in the json response
    protected $appends = ['available','slot_status','start_time_12_format','end_time_12_format'];
       
    public function Court(){
        return $this->hasOne(Venue::class,'id','court_id');
    }

    public function booking(){
    return $this->hasMany(CouchingBooking::class,'cst_id','id');
    }

    public function getAvailableAttribute(){
        return $this->max_join - $this->booking_count;
    }
    public function getSlotStatusAttribute(){
        return ($this->getAvailableAttribute()<=0) ? 'closed': 'open'; 
    }

    public function getStartTime12FormatAttribute(){
        return date("h.i A", strtotime($this->start_time));
    }
    public function getEndTime12FormatAttribute(){
        return date("h.i A", strtotime($this->end_time));
    }
}
