<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Complaint extends Model
{
    use HasFactory;
    protected $table="complaints";
    public function getImageAttribute($value)
    {
        return config('app.url')."".$this->attributes['image'];
    }

    public function complainttype(){
       return $this->hasOne(ComplaintTypes::class,'id','issue_type');
    }
  

    public function getCreatedAtAttribute()
{
    return Carbon::createFromFormat('Y-m-d H:i:s', $this->attributes['created_at'])->format('d-m-Y');
}

}
