<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Admin\Category;
use App\Models\Sports;
use App\Models\Venue;
use App\Models\Coaching;
use App\Models\CoachingTimings;

class CouchingBooking extends Model
{
  
    use HasFactory;
    Protected $table='couching_booking';
    protected $fillable = [
        'player_id', 'sports_id', 'court_id' ,'cst_id' ,'join_date' ,'ending_date' ,'amount' ,'date' ,'payment_status' ,'slot_status'
    ];
       protected $casts = [
        'amount' => 'string', 
     
    ];
    public function sportsName(){
        return $this->belongsTo(Sports::class,'sports_id','id');
    }

    public function courtName(){
        return $this->belongsTo(Venue::class,'court_id','id');
    }

    public function SessionName(){
        return $this->belongsTo(Coaching::class,'session_id','id');
    }

    public function Timings(){
       return $this->belongsTo(CoachingTimings::class,'cst_id','id');
    }

    public function CoachingHistory(){
        return $this->hasOne(CoachingHistory::class,'booking_id','id');
    }
    public function player(){
        return $this->belongsTo(Customer::class,'player_id','id');
    }

}
