<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Models\Admin\Category;
use App\Models\Sports;
class Court extends Model
{
    use HasFactory;
    use Sluggable;
    Protected $table="court";
    protected $fillable = [
        'name', 'court_name', 'category_id','sports_id','venue_id','image','status','slug'
    ];
       

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function category(){
        return $this->belongsTo(Category::class,'category_id','id');
    }
    public function sports(){
        return $this->belongsTo(Sports::class,'sports_id','id');
    }
    public function venue(){
        return $this->belongsTo(Venue::class,'venue_id','id');
    }
}
