<?php

namespace App\Models;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Customer extends Model
{
    use HasApiTokens, HasFactory, Notifiable;
    protected $table="players";
    protected $fillable = [
        'name',
        'email',
        'password',
        'mobile',
        'photo',
        'status',
        'otp',
        'otp_time',
        'otp_verify',
        'from_referal',
        'referal_code'
    ];
         protected $casts = [
       // Make sure 'id' is cast as an integer.
        'email_verified_at' => 'datetime',
    ];
    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
  
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */

    public function getPhotoAttribute($value)
    {
        return config('app.url')."".$this->attributes['photo'];
    }
    public function  getEmailAttribute($value)
    {
        return $value ?? '';
    }
    public function memership(){
        
    }
    public function bookings(){
        return $this->hasMany(Booking::class,'player_id','id');
    }
}
