<?php

namespace App\Models\Membership;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MembershipPackage extends Model
{

    
    use HasFactory;
    protected $table="mem_package";
    protected $fillable=['dur_id','plan_id','discount','price','image_json','membership_description'];
             protected $casts = [
          'dur_id'=>'string',
               'plan_id'=>'string',
                 'discount'=>'string',
                   'price'=>'string',

    ];
    public function duration(){
        return $this->hasOne(MembershipDuration::class,'id','dur_id');
    }
    public function plan(){
        return $this->hasOne(MembershipPlans::class,"id","plan_id");
    }
    public function getImageJsonAttribute($value)
    {
        return config("app.url")."".$this->attributes["image_json"];
    }

    public function getMembershipDescriptionAttribute($value){
        return json_decode(($this->attributes["membership_description"]),true);
    }
}
