<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class PlayCoinHistory extends Model
{
    use HasFactory;
    Protected $table="players_play_coin_history";

    protected $attributes = ['date'];

  protected $casts = [
        'coins' => 'string', // Make sure 'id' is cast as an integer.
        'balance'=>'string'
    ];
    //Make it available in the json response
    protected $appends = ['date'];
 
    public function getDateAttribute(){
        return Carbon::parse($this->createdAt)->format('d-m-Y');
        
    }

}
