<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class PlayerMembership extends Model
{
    use HasFactory;
    Protected $table="mem_purchase";
    protected $fillable=[
        'pack_id',
        'start_date',
        'end_date',
        'player_id' ,
        'dis_per',
        'status' ,
        'amount'
        ];
     
    public function getStatusAttribute($value) {
        $datework = Carbon::createFromDate($this->end_date)->timestamp;
        $now = Carbon::now()->timestamp;
        return ($now <=$datework) ? 'active' : 'expired'   ;
    }

    public function package(){
        return $this->hasOne(Membership\MembershipPackage::class,'id','pack_id');
    }
    
}
