<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Review extends Model
{
    use HasFactory;

    Protected $table="reviews";
    protected $attributes = ['date'];
 
    //Make it available in the json response
    protected $appends = ['date'];
    public function player(){
        return $this->belongsTO(Customer::class,'player_id','id');
    }

    public function court(){
        return $this->belongsTO(Venue::class,'court_id','id');
    }

 
 
     public function getDateAttribute(){
         return Carbon::parse($this->createdAt)->format('d-m-Y');
         
     }

}

