<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SlotTime extends Model
{
    use HasFactory;
    Protected $table="slots_timing";
    protected $fillable = [
        'day_id', 'slot_id', 'price','time_from','time_to','golden_hour','status'
    ];
    protected $attributes = ['start_time_12_format','end_time_12_format'];
  
    //Make it available in the json response
    protected $appends = ['start_time_12_format','end_time_12_format'];

    public function getStartTime12FormatAttribute(){
        return date("h.i A", strtotime($this->time_from));
    }

    public function getEndTime12FormatAttribute(){
        return date("h.i A", strtotime($this->time_to));
    }
    
    public function getPriceAttribute(){
       
        if(isMembershipActive(auth('sanctum')->user()->id) && $this->attributes['golden_hour']!=0){
           return $this->attributes['golden_price'];
        }else{
           return $this->attributes['price'];
           
        }
     
   }
}
