<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\SlotTime;
class Slots extends Model
{
    use HasFactory;
    Protected $table="slots";
    protected $fillable = [
        'day_id', 'start_time', 'end_time','slot_break_time','slot_duration','price_per_slot','time_off','court_id'
    ];
     protected $casts = [
        'price' => 'string', 
     
    ];
    
    public function slotTime(){
       return $this->hasMany(SlotTime::class,'slot_id','id');
    }
}
