<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Models\Admin\Category;
class Sports extends Model
{
    use HasFactory;
    use Sluggable;
    Protected $table="sports";
    protected $fillable = [
        'name', 'image', 'slug','category','background_image','image_json','type','sports_description','Status','price','member_price'
    ];
     protected $casts = [
      
        'category'=>'string',
        'status'=>'string',
        'booking_count'=>'string'
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }


    public function category(){
        return $this->belongsTo(Category::class,'category','id');
    }
    public function cat(){
        return $this->belongsTo(Category::class,'category','id');
    }

    public function getImageAttribute($value)
    {
        return config('app.url')."".$this->attributes['image'];
    }

    public function booking(){
        return $this->hasMany(Booking::class,'sports_id','id');
    }

    public function getImageJsonAttribute($value)
    {

        return config('app.url')."".$this->attributes['image_json'];
    }

    public function getBackgroundImageAttribute($value)
    {

        return config('app.url')."".$this->attributes['background_image'];
    }
    
    public function getBookingSumPriceAttribute($val)
    {
        return $val ?? 0;
    }

    public function bookingReports(){
        return $this->hasMany(BookingSlotHistory::class,'sports_id','id');
    }
    
}
