<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;
use App\Models\Admin\Category;
use App\Models\Sports;
class Venue extends Model
{
    use HasFactory;
    use Sluggable;
    Protected $table="venues";
    protected $fillable = [
        'name', 'sports_category', 'sports','slug','image'
    ];
     protected $casts = [
      
        'sports_category' => 'string',
         'booking_count'=>'string'
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function category(){
        return $this->belongsTo(Category::class,'id','sports_category');
    }
    public function sports(){
        return $this->belongsTo(Sports::class,'sports','id');
    }
    public function getImageAttribute($value)
    {
        return config('app.url')."".$this->attributes['image'];
    }
   
    public function booking(){
        return $this->hasMany(Booking::class,'court_id','id');
    }


}
