<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class IntegerToStringCastingProvider extends ServiceProvider
{
    public function boot()
    {
        // Register a global scope to cast integer attributes to strings.
        \Illuminate\Database\Eloquent\Builder::macro('castIntegersToStrings', function () {
            $this->getModel()->addGlobalScope('cast_integers_to_strings', function ($builder) {
                foreach ($builder->getModel()->getIntegersToStrings() as $attribute) {
                    $builder->addSelect([
                        $attribute,
                        \DB::raw("CAST($attribute AS CHAR) as $attribute")
                    ]);
                }
            });
        });
    }

    public function register()
    {
        // Register the service.
    }
}
