"use strict";
var form = document.querySelector('#category_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal=$('#kt_modal_new_target');
var validator;
$.ajaxSetup({
	headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	}
});
var sports_category = {
    init: function() {
        ! function() {
            const t = $("#category_table");
			var table = $("#category_table").DataTable({
                
                url: "{{route('admin.categories.index')}}",
                type: "POST",
                processing: true,
                serverSide: true,
			    stateSave: true ,
				bDestroy:true,
				
				
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                    {data: 'image', name: 'image'},
                    {data: 'slug', name: 'slug'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ],
                columnDefs: [
                    { targets: 2,
                      render: function(data) {
                        if(data){
                           
                            return '<img src="'+data+'">'
                        }
                       
                     
                      }
                    }   
                  ]

            });
			$('table').on('draw.dt', function() {
				$('[data-bs-toggle="tooltip"]').tooltip();
			})

				
        }()
    }

    
};

var handleForm = function() {

	// Stepper custom navigation
   $('.invalid-feedback').remove();
	// Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
	validator = FormValidation.formValidation(
		form,
		{
			fields: {
				
				category_name: {
					validators: {
						notEmpty: {
							message: 'Category Name is Required'
						}
					}
				},
				
				'targets_notifications[]': {
					validators: {
						notEmpty: {
							message: 'Please select at least one communication method'
						}
					}
				},
			},
			plugins: {
				trigger: new FormValidation.plugins.Trigger(),
				bootstrap: new FormValidation.plugins.Bootstrap5({
					rowSelector: '.fv-row',
					eleInvalidClass: '',
					eleValidClass: ''
				})
			}
		}
		
	);


}

$(document).on("click",".edit_category",function() {
    let data_id=$(this).attr('data-id');
	let c_edit=cat_edit.replace(':id',data_id);
	
	axios.get(c_edit, {
		'_method': 'GET',
		'dataType':'JSON'

	})
	.then(function(response) {
		response=(response.data);
		$('#kt_modal_new_target').modal('toggle');
		$('.add-label').html('Edit Category');
		$('#category_name').val(response.data.name);
		$('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+response.data.image+"')");
		$('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="category_id" value="'+data_id+'" id="edit_category_id">');

	}).catch(function(error){

	});
});
$('#kt_modal_new_target').on('hidden.bs.modal', function () {
	  $('.add-label').html('Add Category');
	  form.reset();
	  $('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
	  $('#append_div').empty();					
  })
$(document).on("click",".delete_category",function(e) {
	
	var data_id=$(this).attr('data-id');
	var cat_delete1=cat_delete.replace(':id',data_id);
	e.preventDefault();
	
	Swal.fire({
		title: 'Are you sure to delete this record?',
		showDenyButton: true,
	
		confirmButtonText: 'Yes',
		
	  }).then((result) => {
		/* Read more about isConfirmed, isDenied below */
		if (result.isConfirmed) {
			axios.delete(cat_delete1, {
				'_method': 'DELETE',
				'dataType':'JSON'
		
			})
			.then(function(response) {
				{
					response=(response.data)
					if(response.success){
					
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#category_table").DataTable().ajax.reload(null, false);
							}
						});
					}else{
						Swal.fire({
							text: response.message,
							icon: "danger",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-danger"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								$("#category_table").DataTable().ajax.reload(null, false);
							}
						});
					}
				};
			})
			.catch(function(error) {
				console.log(error.response.data.responseMessage);
				let dataMessage = error.response.data.responseMessage;
					//let dataErrors = error.response.data.responseMessage;
					
					

					if (error.response) {
						Swal.fire({
							text: dataMessage,
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
			});
		} else if (result.isDenied) {
		  //Swal.fire('Changes are not saved', '', 'info')
		}
	  })
   

  




});
$(document).on("click","#add_category",function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit',"#category_form",function(){
	var cid=($('#edit_category_id').val());
	var method;
	var action;
	if(!cid){
		action=cat_store;
	}else{
		action=cat_update;
		action=action.replace(':id',cid);
	}
	$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
	handleForm();
	if (validator) {
		// Validate form
		validator.validate().then(function (status) {
			$('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
			if (status === 'Valid') {
				// Send ajax request
				axios.post(action,new FormData(form))
				.then(function (response) {
					response=response.data;
					if(response.success){
						Swal.fire({
							text: response.message,
							icon: "success",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						}).then(function (result) {
							if (result.isConfirmed) {
								form.reset(); // Reset form	
								$('#kt_modal_new_target').modal('toggle');
								$('.image-input-wrapper').attr('style',"background-image: url('"+hostUrl+"admin/assets/media/avatars/upload.png')");
								$("#category_table").DataTable( ).ajax.reload(null, false);
							}
						});
					}
					
					
				})
				.catch(function (error) {
					console.log(error)
					let dataMessage = error.response.data.responseMessage;
					//let dataErrors = error.response.data.responseMessage;
					
					

					if (error.response) {
						Swal.fire({
							text: dataMessage,
							icon: "error",
							buttonsStyling: false,
							confirmButtonText: "Ok, got it!",
							customClass: {
								confirmButton: "btn btn-primary"
							}
						});
					}
				})
				.then(function () {
					// always executed
					// Hide loading indication
					submitButton.removeAttribute('data-kt-indicator');

					// Enable button
					submitButton.disabled = false;
					
				});
             
			}else{
				
			}
          
		});

	}
    return false;
});

$(function() {
	sports_category.init();
	
	

  });