"use strict";
var form = document.querySelector('#sports_form');

var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var validator;
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var players = {
    init: function() {
        ! function() {
            const t = $("#booking_table");
            $("#booking_table").DataTable({
                type: "GET",
                  processing: true,
                  serverSide: true,
                  stateSave: true,
                  bDestroy: true,
                  bPaginate: true,
                  searching: false ,
                  showing: false ,
                  lengthChange: false ,
             
                ajax: {
                  url: coach_index,
                  data: function (d) {
                      d.sports= $('select[name="book_sport"]').find(":checked").text();
                      d.court= $('select[name="book_court"]').find(":checked").text();
                      d.status= $('select[name="book_status"]').find(":checked").val();
                      d.date= $('#book_date').val();
                    
                    }
                },
                columns: [
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex', searchable: false, orderable: false
                    },
                  
                    {
                        data: 'player.name',
                        name: 'player.name'
                    },
                   
                    {
                        data: 'player.mobile',
                        name: 'player.mobile'
                    },
                    {
                        data: 'sports_name.name',
                        name: 'sports_name.name'
                    },
                  
                    {
                        data: 'court_name.name',
                        name: 'court_name.name'
                    },
                    {
                        data: 'session_name.group',
                        name: 'session_name.group'
                    },
                    {
                        data: 'timings.start_time',
                        name: 'start_time'
                    },
                    {
                        data: 'join_date',
                        name: 'join_date'
                    },
                    {
                        data: 'ending_date',
                        name: 'ending_date'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'slot_status',
                        name: 'slot_status'
                    },
                    
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                columnDefs: [
                    {
                        targets: 6,
                        data : 'start_time',
                        render: function ( data, type, row ) {
                        return row.timings.start_time +'-'+ row.timings.end_time;
                      }
                    }
              ]

            })
        }()
    }


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                customer_name: {
                    validators: {
                        notEmpty: {
                            message: 'Customer Name is Required'
                        }
                    }
                },
                customer_gender: {
                    validators: {
                        notEmpty: {
                            message: 'Gender Type is Required'
                        }
                    }
                },
                customer_mobile: {
                    validators: {
                        notEmpty: {
                            message: 'Mobile is Required'
                        }
                    }
                },
                customer_status: {
                    validators: {
                        notEmpty: {
                            message: 'Please select status'
                        }
                    }
                },
               
              'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {

                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}


$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add sports');
    form.reset();
    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
    $('#append_div').empty();
})
$(document).on("click", ".delete_customer", function(e) {

    var data_id = $(this).attr('data-id');
    var ply_delete1 = ply_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(ply_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#booking_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#booking_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#sports_form", function() {
    
    var cid = ($('#edit_player_id').val());
    var method;
    var action;
    if (!cid) {
        action = ply_store;
    } else {
        action = ply_update;
        action = action.replace(':id', cid);
    }
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();
    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#booking_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});

$(function() {
    players.init();



});


$(document).on("click", ".view_courts", function() {
    var cid=($(this).attr('data-id'));
    var url=spo_view_courts.replace(':id', cid);
    location.href=url;
    
});

$('#customer-filter-form').submit(function(){

   $("#booking_table").DataTable().ajax.reload(null, false);
    return false;

});

$('.filter_reset').click(function(){

    $('#customer-filter-form').trigger('reset').submit();
    

});

$('#cus_export').click(function(){

    var query = {
     
         sports :  $('select[name="book_sport"]').find(":checked").text() ,
         court:  $('select[name="book_court"]').find(":checked").text() ,
          status: $('select[name="book_status"]').find(":checked").val() ,
          date:$('#book_date').val()
    }

    var url = book_exports +'?'+ $.param(query);

    window.location = url;
}); 


$('select[name="book_sport"]').on('change', function() {
   
    var cid=( $(this).find(":checked").val() );
   // $('select[name="court_sports"]').find('option').remove();
   
    var get_courts2=get_courts.replace(":id",cid);
    axios.get(get_courts2, {
        '_method': 'GET',
        'dataType': 'JSON'

    })
    .then(function(response) {
        response = (response.data);
        var opt;
        $('select[name="book_court"]').find('option')
        .remove();
        var opt="<option></option>";
        $.each(response.data, function (key, val) {
          
            opt+="<option value="+val.id+">"+val.name+"</option>";
        });

        $('select[name="book_court"]').append(opt); 
                 
    }).catch(function(error) {

    });
});


$(document).on("change", "select[name='payment_status']", function() {
    var refund=($(this).val());
    if(refund=='refund'){
        $('#dynamic_append').empty().append(' <div class="row"> <div class="col"> <div class="d-flex flex-column mb-8 fv-row"> <label class="d-flex align-items-center fs-6 fw-semibold mb-2"> <span class="required">Refund Amount</span> <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip" title="Please select duration"></i> </label> <div> <input type="text" class="form-control form-control-solid" placeholder="Please enter refund amount" name="refund_amount" id="refund_amount" autocomplete="off"> </div></div></div><div class="col"> <div class="d-flex flex-column mb-8 fv-row"> <label class="d-flex align-items-center fs-6 fw-semibold mb-2"> <span class="required">Remarks</span> <i class="fas fa-exclamation-circle ms-2 fs-7" data-bs-toggle="tooltip" title="Please select duration"></i> </label> <div> <input type="text" class="form-control form-control-solid" placeholder="Please enter refund amount" name="refund_amount" id="refund_amount" autocomplete="off"> </div></div></div></div>');
        $('select[name="booking_status"] option[value="canceled"]').attr('selected', 'selected').trigger('change');
            
 
    }else{
        $('#dynamic_append').empty();
    }
});



$(document).on("click", ".edit_coaching", function() {
    let data_id = $(this).attr('data-id');
    let c_edit = coaching_edit.replace(':id', data_id);
    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'
         })
        .then(function(response) {
           response = (response.data);
            $('#kt_modal_new_target').modal('show');
            $('#modal_append').empty().append(response);
            $('.add-label').html('Edit Booking');
            $('#customer_name').val(response.data.name);
            $('#customer_mobile').val(response.data.mobile);
            $('select[name="customer_gender"] option[value="'+response.data.gender+'"]').attr('selected', 'selected').trigger('change');
            $('select[name="customer_status"] option[value="'+response.data.status+'"]').attr('selected', 'selected').trigger('change');
            $('.sport_img').attr('style', "background-image: url('"+ response.data.photo + "')");
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="player_id" value="' + data_id + '" id="edit_player_id">');
           
        }).catch(function(error) {

        });
});


$(document).on('submit', "#booking_edit_form", function() {
  
   let booking_form = document.querySelector('#booking_edit_form');
    axios.post(save_book_edit, new FormData(booking_form))
    .then(function(response) {
        response = response.data;
     

    })
    .catch(function(error) {
        console.log(error)
     
    })
    .then(function() {
        // always executed
        // Hide loading indication
        submitButton.removeAttribute('data-kt-indicator');

        // Enable button
        submitButton.disabled = false;

    });

    return false;

});

