"use strict";
var form = document.querySelector('#membership_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var validator;
var table_name = $("#membership_table");
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var sports_sports = {
    init: function() {
        ! function() {
           
            table_name.DataTable({

                url: "{{route('admin.categories.index')}}",
                type: "POST",
                processing: true,
                serverSide: true,
                stateSave: true,
                bDestroy: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'duration.dur_name',
                        name: 'duration'
                    },
                    {
                        data: 'plan.plan_name',
                        name: 'plan'
                    },
                    {
                        data: 'discount',
                        name: 'discount'
                    },
                    {
                        data: 'price',
                        name: 'price'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]

            })
        }()
    }


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                mem_duration: {
                    validators: {
                        notEmpty: {
                            message: 'Please Select Membership Duration'
                        }
                    }
                },
                mem_package: {
                    validators: {
                        notEmpty: {
                            message: 'Please select Membership Package'
                        }
                    }
                },
                mem_discount: {
                    validators: {
                        notEmpty: {
                            message: 'Plese enter  discount value'
                        }
                    }
                },
                mem_discount_type: {
                    validators: {
                        notEmpty: {
                            message: 'Please select discount type'
                        }
                    }
                },
            //    image_json: {
            //         validators: {
            //             notEmpty: {
            //                 message: 'Please choose image json'
            //             }
            //         }
            //     },
       
            },
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}

$(document).on("click", ".edit_membership", function() {
    let data_id = $(this).attr('data-id');
    let c_edit = membership_edit.replace(':id', data_id);

    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'

        })
        .then(function(response) {
            response = (response.data);
            $('#kt_modal_new_target').modal('toggle');
            $('.add-label').html('Edit Plans');
            $('#mem_discount').val(response.data.discount);
            $('#mem_price').val(response.data.price);
            $('select[name="mem_package"] option[value="'+response.data.plan_id+'"]').attr('selected', 'selected').trigger('change');
            $('select[name="mem_duration"]').val(response.data.dur_id).attr('selected', 'selected').trigger('change');
            $('select[name="mem_discount_type"]').val(response.data.discount_type).trigger('change');
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="plan_id" value="' + response.data.id + '" id="edit_plan_id">');
           //console.log(response.data.membership_description);
            var tr;
            $("#membership_desc_table > tbody").empty();
            var i=0; 
            $.each(response.data.membership_description, function (key, val) {
                if(i==0){
                    tr+='<tr><td><div class="input-group flex-nowrap"><input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title[]" value="'+val.title+'"> </div></td><td><div class="input-group flex-nowrap"><input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title1[]" value="'+val.offer+'"> </div></td><td> <div class="input-group flex-nowrap"> <textarea class="form-control" name="mem_dec_desc[]">'+val.description+'</textarea> </div></td><td> <button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto add_membership_desc" data-id="" id=""> <span class="svg-icon svg-icon-muted svg-icon-2hx"> <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <rect opacity="0.3" x="2" y="2" width="20" height="20" rx="10" fill="currentColor"></rect> <rect x="10.8891" y="17.8033" width="12" height="2" rx="1" transform="rotate(-90 10.8891 17.8033)" fill="currentColor"></rect> <rect x="6.01041" y="10.9247" width="12" height="2" rx="1" fill="currentColor"></rect> </svg> </span> </button> </td></tr>';
                }else{
                    tr+='<tr><td><div class="input-group flex-nowrap"><input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title[]" value="'+val.title+'"> </div></td><td><div class="input-group flex-nowrap"><input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title1[]" value="'+val.offer+'"> </div></td><td> <div class="input-group flex-nowrap"> <textarea class="form-control" name="mem_dec_desc[]">'+val.description+'</textarea> </div></td><td><button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto delete_member_desc" data-id="" id="kt_users_delete_two_step"><span class="svg-icon svg-icon-3"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path> <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path> <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path></svg></span> </button></td></tr>';
                }
                i++;
                 });

           $("#membership_desc_table > tbody").append(tr);
        }).catch(function(error) {

        });
});
$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add plans');
    form.reset();
   // $('select[name="mem_duration"]').empty().trigger('change');
  //  $('select[name="mem_package]').empty().trigger('change');
    $('#append_div').empty();
})
$(document).on("click", ".delete_membership", function(e) {

    var data_id = $(this).attr('data-id');
    var membership_delete1 = membership_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(membership_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    table_name.DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    table_name.DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#membership_form", function() {
    

    var cid = ($('#edit_plan_id').val());
    var method;
    var action;
    if (!cid) {
        action = membership_store;
    } else {
        action = membership_update;
        action = action.replace(':id', cid);
    }
   
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();

    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#membership_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});


$(document).on('click', ".add_membership_desc", function() {
     $('#membership_desc_table tr:last').after('<tr> <td> <div class="input-group flex-nowrap"> <input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title[]" autocomplete="off"> </div></td><td><div class="input-group flex-nowrap"><input type="text" class="form-control" placeholder="Enter Dec Title" name="mem_dec_title1[]"> </div></td><td> <div class="input-group flex-nowrap"> <textarea class="form-control" name="mem_dec_desc[]"></textarea> </div></td><td> <button type="button" class="btn btn-icon btn-active-light-primary w-30px h-30px ms-auto delete_member_desc" data-id="" id="kt_users_delete_two_step"><span class="svg-icon svg-icon-3"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M5 9C5 8.44772 5.44772 8 6 8H18C18.5523 8 19 8.44772 19 9V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V9Z" fill="currentColor"></path> <path opacity="0.5" d="M5 5C5 4.44772 5.44772 4 6 4H18C18.5523 4 19 4.44772 19 5V5C19 5.55228 18.5523 6 18 6H6C5.44772 6 5 5.55228 5 5V5Z" fill="currentColor"></path> <path opacity="0.5" d="M9 4C9 3.44772 9.44772 3 10 3H14C14.5523 3 15 3.44772 15 4V4H9V4Z" fill="currentColor"></path></svg></span> </button> </td></tr>');
});

$(document).on('click','.delete_member_desc',function(){
    console.log($(this).parents('tr').remove());
});

$(function() {
    sports_sports.init();
});