"use strict";
var form = document.querySelector('#sports_form');
var submitButton = document.querySelector('#kt_modal_new_target_submit');
var modal = $('#kt_modal_new_target');
var validator;
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
var players = {
    init: function() {
        ! function() {
            const t = $("#players_table");
            $("#players_table").DataTable({
                type: "GET",
                  processing: true,
                  serverSide: true,
                  stateSave: true,
                  bDestroy: true,
                  bPaginate: true,
                  searching: false ,
                  showing: false ,
                  lengthChange: false ,
             
                ajax: {
                  url: ply_index,
                  data: function (d) {
                      d.gender= $('select[name="cs_gender"]').find(":checked").val();
                      d.status= $('select[name="cs_status"]').find(":checked").val();
                      d.mobile= $('#cs_mobile').val();
                      d.name= $('#cs_name').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex', searchable: false, orderable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'gender',
                        name: 'gender'
                    },
                    {
                        data: 'photo',
                        name: 'photo'
                    },
                  
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'bookings_count',
                        name: 'bookings_count'
                    },
                    
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                columnDefs: [{
                    targets: 4,
                    render: function(data) {
                        if (data) {

                            return '<img src="' + data + '" width="100px" height="auto">'
                        }


                    }
                }]

            })
        }()
    }


};

var handleForm = function() {

    // Stepper custom navigation
    $('.invalid-feedback').remove();
    // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
    validator = FormValidation.formValidation(
        form, {
            fields: {

                customer_name: {
                    validators: {
                        notEmpty: {
                            message: 'Customer Name is Required'
                        }
                    }
                },
                customer_gender: {
                    validators: {
                        notEmpty: {
                            message: 'Gender Type is Required'
                        }
                    }
                },
                customer_mobile: {
                    validators: {
                        notEmpty: {
                            message: 'Mobile is Required'
                        }
                    }
                },
                customer_status: {
                    validators: {
                        notEmpty: {
                            message: 'Please select status'
                        }
                    }
                },
               
              'targets_notifications[]': {
                    validators: {
                        notEmpty: {
                            message: 'Please select at least one communication method'
                        }
                    }
                },
            },
            plugins: {

                trigger: new FormValidation.plugins.Trigger(),
                bootstrap: new FormValidation.plugins.Bootstrap5({
                    rowSelector: '.fv-row',
                    eleInvalidClass: '',
                    eleValidClass: ''
                })
            }
        }

    );


}

$(document).on("click", ".edit_customer", function() {
    let data_id = $(this).attr('data-id');
    let c_edit = ply_edit.replace(':id', data_id);
    axios.get(c_edit, {
            '_method': 'GET',
            'dataType': 'JSON'
         })
        .then(function(response) {
            response = (response.data);
            $('#kt_modal_new_target').modal('toggle');
            $('.add-label').html('Edit Customer');
            $('#customer_name').val(response.data.name);
            $('#customer_mobile').val(response.data.mobile);
            $('select[name="customer_gender"] option[value="'+response.data.gender+'"]').attr('selected', 'selected').trigger('change');
            $('select[name="customer_status"] option[value="'+response.data.status+'"]').attr('selected', 'selected').trigger('change');
            $('.sport_img').attr('style', "background-image: url('"+ response.data.photo + "')");
            $('#append_div').html('<input type="hidden" name="_method" value="PUT"><input type="hidden" name="player_id" value="' + data_id + '" id="edit_player_id">');
           
        }).catch(function(error) {

        });
});
$('#kt_modal_new_target').on('hidden.bs.modal', function() {
    $('.add-label').html('Add sports');
    form.reset();
    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
    $('#append_div').empty();
})
$(document).on("click", ".delete_customer", function(e) {

    var data_id = $(this).attr('data-id');
    var ply_delete1 = ply_delete.replace(':id', data_id);
    e.preventDefault();

    Swal.fire({
        title: 'Are you sure to delete this record?',
        showDenyButton: true,

        confirmButtonText: 'Yes',

    }).then((result) => {
        /* Read more about isConfirmed, isDenied below */
        if (result.isConfirmed) {
            axios.delete(ply_delete1, {
                    '_method': 'DELETE',
                    'dataType': 'JSON'

                })
                .then(function(response) {
                    {
                        response = (response.data)
                        if (response.success) {

                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#players_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        } else {
                            Swal.fire({
                                text: response.message,
                                icon: "danger",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    $("#players_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }
                    };
                })
                .catch(function(error) {
                    console.log(error);
                });
        } else if (result.isDenied) {
            //Swal.fire('Changes are not saved', '', 'info')
        }
    })




});
$(document).on("click", "#add_sports", function() {
    $('#kt_modal_new_target').modal('show');
});

$(document).on('submit', "#sports_form", function() {
    
    var cid = ($('#edit_player_id').val());
    var method;
    var action;
    if (!cid) {
        action = ply_store;
    } else {
        action = ply_update;
        action = action.replace(':id', cid);
    }
    $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'on');
    handleForm();
    if (validator) {
        // Validate form
        validator.validate().then(function(status) {
            $('#kt_modal_new_target_submit').attr('data-kt-indicator', 'off');
            if (status === 'Valid') {
                // Send ajax request
                axios.post(action, new FormData(form))
                    .then(function(response) {
                        response = response.data;
                        if (response.success) {
                            Swal.fire({
                                text: response.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            }).then(function(result) {
                                if (result.isConfirmed) {
                                    form.reset(); // Reset form	
                                    $('#kt_modal_new_target').modal('toggle');
                                    $('.image-input-wrapper').attr('style', "background-image: url('" + hostUrl + "admin/assets/media/avatars/upload.png')");
                                    $("#players_table").DataTable().ajax.reload(null, false);
                                }
                            });
                        }


                    })
                    .catch(function(error) {
                        console.log(error)
                        let dataMessage = error.response.data.message;
                        let dataErrors = error.response.data.errors;

                        for (const errorsKey in dataMessage) {
                            if (!dataErrors.hasOwnProperty(errorsKey))
                                continue;
                            dataMessage += "\r\n" + dataErrors[errorsKey];

                        }

                        if (error.response) {
                            Swal.fire({
                                text: dataMessage,
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn btn-primary"
                                }
                            });
                        }
                    })
                    .then(function() {
                        // always executed
                        // Hide loading indication
                        submitButton.removeAttribute('data-kt-indicator');

                        // Enable button
                        submitButton.disabled = false;

                    });

            } else {

            }

        });

    }
    return false;
});

$(function() {
    players.init();



});


$(document).on("click", ".view_courts", function() {
    var cid=($(this).attr('data-id'));
    var url=spo_view_courts.replace(':id', cid);
    location.href=url;
    
});

$('#customer-filter-form').submit(function(){

   $("#players_table").DataTable().ajax.reload(null, false);
    return false;

});

$('.filter_reset').click(function(){

    $('#customer-filter-form').trigger('reset').submit();
    

});

$('#cus_export').click(function(){

    var query = {
        gender: $('select[name="cs_gender"]').find(":checked").val(),
        status: $('select[name="cs_status"]').find(":checked").val(),
        mobile: $('#cs_mobile').val(),
        name: $('#cs_name').val(),
    }

    var url = ply_exports +'?'+ $.param(query);

    window.location = url;
}); 